/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.validation.swingui;

import ca.sqlpower.validation.Status;
import ca.sqlpower.validation.ValidateResult;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.StatusComponent;
import ca.sqlpower.validation.swingui.ValidationHandler;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormValidationHandler
implements ValidationHandler {
    private static final Logger logger = Logger.getLogger(FormValidationHandler.class);
    protected static final Color COLOR_ERROR = new Color(255, 170, 170);
    protected static final Color COLOR_WARNING = Color.YELLOW;
    private StatusComponent display;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private List<ValidateObject> objects;
    private ValidateResult worstValidationStatus;
    private boolean havePerformedValidation;

    public FormValidationHandler(StatusComponent display) {
        this.display = display;
        this.objects = new ArrayList<ValidateObject>();
    }

    @Override
    public void addValidateObject(final JComponent component, Validator validator) {
        final ValidateObject validateObject = new ValidateObject(component, validator);
        this.objects.add(validateObject);
        if (component instanceof JTextComponent) {
            validateObject.setObject(((JTextComponent)component).getText());
            ((JTextComponent)component).getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    this.doStuff();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.doStuff();
                }

                public void changedUpdate(DocumentEvent e) {
                    this.doStuff();
                }

                private void doStuff() {
                    validateObject.setObject(((JTextComponent)component).getText());
                    FormValidationHandler.this.performFormValidation();
                }
            });
        } else if (component instanceof JComboBox) {
            validateObject.setObject(((JComboBox)component).getSelectedItem());
            ((JComboBox)component).addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    validateObject.setObject(((JComboBox)component).getSelectedItem());
                    FormValidationHandler.this.performFormValidation();
                }
            });
        } else if (component instanceof AbstractButton) {
            validateObject.setObject(((AbstractButton)component).isSelected());
            ((AbstractButton)component).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    validateObject.setObject(((AbstractButton)component).isSelected());
                    FormValidationHandler.this.performFormValidation();
                }
            });
        } else if (component instanceof JTable) {
            JTable table = (JTable)component;
            final TableModel tableModel = table.getModel();
            validateObject.setObject(tableModel);
            final TableModelListener tableModelListener = new TableModelListener(){

                public void tableChanged(TableModelEvent arg0) {
                    validateObject.setObject(tableModel);
                    FormValidationHandler.this.performFormValidation();
                }
            };
            tableModel.addTableModelListener(tableModelListener);
            table.addPropertyChangeListener("model", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    TableModel old = (TableModel)evt.getOldValue();
                    old.removeTableModelListener(tableModelListener);
                    TableModel newModel = (TableModel)evt.getNewValue();
                    newModel.addTableModelListener(tableModelListener);
                    FormValidationHandler.this.performFormValidation();
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported JComponent type:" + component.getClass());
        }
    }

    private void performFormValidation() {
        ValidateResult worst = null;
        for (ValidateObject o : this.objects) {
            o.doValidate();
            if (o.getResult() == null) continue;
            if (o.getResult().getStatus() == Status.FAIL && (worst == null || worst.getStatus() != Status.FAIL)) {
                worst = o.getResult();
                continue;
            }
            if (o.getResult().getStatus() == Status.WARN && (worst == null || worst.getStatus() == Status.OK)) {
                worst = o.getResult();
                continue;
            }
            if (worst != null) continue;
            worst = o.getResult();
        }
        this.setWorstValidationStatus(worst);
        this.display.setResult(worst);
    }

    public ValidateResult getWorstValidationStatus() {
        return this.worstValidationStatus;
    }

    private void setWorstValidationStatus(ValidateResult result) {
        ValidateResult oldResult = this.worstValidationStatus;
        this.worstValidationStatus = result;
        this.pcs.firePropertyChange("worstValidationStatus", oldResult, result);
    }

    public List<String> getFailResults() {
        return this.getResults(Status.FAIL);
    }

    public List<String> getWarnResults() {
        return this.getResults(Status.WARN);
    }

    private List<String> getResults(Status status) {
        ArrayList<String> msg = new ArrayList<String>();
        for (ValidateObject o : this.objects) {
            if (o.getResult() == null || o.getResult().getStatus() != status) continue;
            msg.add(o.getMessage());
        }
        return msg;
    }

    public ValidateResult getResultOf(Object object) {
        for (ValidateObject o : this.objects) {
            if (object != o.getComponent()) continue;
            return o.getResult();
        }
        throw new IllegalArgumentException("Object:" + (object == null ? "null" : object) + " not found!");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeSupport getPCS() {
        return this.pcs;
    }

    public boolean hasPerformedValidation() {
        return this.havePerformedValidation;
    }

    public void resetHasValidated() {
        this.havePerformedValidation = false;
    }

    private class ValidateObject {
        private JComponent component;
        private Object object;
        private Validator validator;
        private Color savedColor;
        private ValidateResult result;

        protected String getMessage() {
            StringBuffer msg = new StringBuffer();
            if (this.getResult() != null) {
                msg.append("[").append(this.getResult().getStatus().name()).append("]");
                msg.append(" ").append(this.getResult().getMessage());
            } else {
                msg.append(" unknown result");
            }
            return msg.toString();
        }

        protected ValidateObject(JComponent component, Validator validator) {
            this.component = component;
            this.validator = validator;
            this.savedColor = component.getBackground();
        }

        protected void doValidate() {
            this.result = this.validator.validate(this.object);
            FormValidationHandler.this.havePerformedValidation = true;
            switch (this.result.getStatus()) {
                case OK: {
                    this.component.setBackground(this.savedColor);
                    break;
                }
                case WARN: {
                    this.component.setBackground(COLOR_WARNING);
                    break;
                }
                case FAIL: {
                    this.component.setBackground(COLOR_ERROR);
                }
            }
        }

        protected Color getSavedColor() {
            return this.savedColor;
        }

        protected ValidateResult getResult() {
            return this.result;
        }

        protected void setObject(Object object) {
            this.object = object;
        }

        protected JComponent getComponent() {
            return this.component;
        }
    }
}

