/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlDebugThread;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.ui.action.ShowGlobalVariableActionDelegate;
import org.epic.debug.ui.action.ShowLocalVariableActionDelegate;
import org.epic.debug.ui.action.ShowPerlInternalVariableActionDelegate;
import org.epic.debug.varparser.PerlDebugValue;
import org.epic.debug.varparser.PerlDebugVar;
import org.epic.debug.varparser.TokenVarParser;

public class StackFrame
extends DebugElement
implements IStackFrame {
    private static final String PADWALKER_ERROR = "PadWalker module not found - please install";
    private static final String DB_DUMP_LOCAL_VARS;
    private static final String DB_DUMP_GLOBAL_VARS;
    private static final IRegisterGroup[] NO_REGISTER_GROUPS;
    private static final Set PERL_INTERNAL_VARS;
    private final PerlDebugThread thread;
    private final IPath path;
    private final IPath localPath;
    private final int lineNumber;
    private final boolean topFrame;
    private final DebuggerInterface db;
    private StackFrame previous;
    private PerlDebugVar[] actualVars;
    private PerlDebugVar[] displayedVars;

    static {
        NO_REGISTER_GROUPS = new IRegisterGroup[0];
        PERL_INTERNAL_VARS = StackFrame.initInternalVars();
        DB_DUMP_LOCAL_VARS = StackFrame.loadHelperScript("dump_local_vars.pl");
        DB_DUMP_GLOBAL_VARS = StackFrame.loadHelperScript("dump_global_vars.pl");
    }

    public StackFrame(PerlDebugThread thread, IPath path, int lineNumber, IPath localPath, DebuggerInterface db, StackFrame previous) throws DebugException {
        super(thread.getDebugTarget());
        this.thread = thread;
        this.path = path;
        this.localPath = localPath;
        this.lineNumber = lineNumber;
        this.topFrame = true;
        this.db = db;
        this.previous = previous;
    }

    public StackFrame(PerlDebugThread thread, IPath path, int lineNumber, IPath localPath, String returnType, String calledSub) throws DebugException {
        super(thread.getDebugTarget());
        this.thread = thread;
        this.path = path;
        this.localPath = localPath;
        this.lineNumber = lineNumber;
        this.topFrame = false;
        this.db = null;
        if (returnType.equals(".")) {
            returnType = "void";
        } else if (returnType.equals("@")) {
            returnType = "list";
        } else if (returnType.equals("$")) {
            returnType = "scalar";
        }
        this.displayedVars = new PerlDebugVar[2];
        this.displayedVars[0] = this.createSpecialVar("Called Function", calledSub);
        this.displayedVars[1] = this.createSpecialVar("Return Type", returnType);
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public void computeDisplayedVars() throws DebugException {
        if (!this.isTopFrame()) {
            return;
        }
        ArrayList<PerlDebugVar> displayed = new ArrayList<PerlDebugVar>(this.actualVars.length);
        int i = 0;
        while (i < this.actualVars.length) {
            if (this.isDisplayedVar(this.actualVars[i])) {
                displayed.add(this.actualVars[i]);
            }
            ++i;
        }
        this.displayedVars = displayed.toArray(new PerlDebugVar[displayed.size()]);
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public IDebugTarget getDebugTarget() {
        return this.thread.getDebugTarget();
    }

    public IPath getLocalPath() {
        return this.localPath;
    }

    public IPath getPath() {
        return this.path;
    }

    public ILaunch getLaunch() {
        return this.thread.getLaunch();
    }

    public int getLineNumber() throws DebugException {
        return this.lineNumber;
    }

    public String getModelIdentifier() {
        return PerlDebugPlugin.getUniqueIdentifier();
    }

    public String getName() throws DebugException {
        return String.valueOf(this.path.lastSegment()) + "[line: " + Integer.toString(this.lineNumber) + "]";
    }

    public PerlDebugThread getPerlThread() {
        return this.thread;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return NO_REGISTER_GROUPS;
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.displayedVars == null && this.topFrame) {
            this.actualVars = this.readTopFrameVars();
            this.computeDisplayedVars();
            this.highlightChangedVariables();
        }
        return this.displayedVars;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.topFrame || this.displayedVars != null && this.displayedVars.length > 0;
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public String toString() {
        return this.path + ":" + this.lineNumber;
    }

    private PerlDebugVar createSpecialVar(String name, String value) {
        PerlDebugVar var = new PerlDebugVar(this.getDebugTarget(), 2, name, new PerlDebugValue(this.getDebugTarget(), null, value));
        var.setSpecial();
        return var;
    }

    private void highlightChangedVariables() throws DebugException {
        if (this.previous == null || !this.previous.getPath().equals((Object)this.getPath())) {
            return;
        }
        this.previous.previous = null;
        PerlDebugVar[] oldVars = (PerlDebugVar[])this.previous.getVariables();
        PerlDebugVar[] newVars = (PerlDebugVar[])this.getVariables();
        int new_pos = 0;
        while (new_pos < newVars.length) {
            boolean found = false;
            PerlDebugVar var_new = newVars[new_pos];
            if (oldVars != null) {
                int org_pos = 0;
                while (org_pos < oldVars.length && !found) {
                    PerlDebugVar var_org = oldVars[org_pos];
                    if (var_new.matches(var_org)) {
                        found = true;
                        var_new.calculateChangeFlags(var_org);
                    }
                    ++org_pos;
                }
                if (!found) {
                    var_new.setChangeFlags(2, true);
                }
            }
            ++new_pos;
        }
    }

    private static Set initInternalVars() {
        ResourceBundle rb = ResourceBundle.getBundle("org.epic.debug.perlIntVars");
        Enumeration<String> e = rb.getKeys();
        HashSet<String> vars = new HashSet<String>();
        while (e.hasMoreElements()) {
            vars.add(e.nextElement());
        }
        return vars;
    }

    private boolean isDisplayedVar(PerlDebugVar var) throws DebugException {
        if (var.isGlobalScope()) {
            boolean isPerlInternal = PERL_INTERNAL_VARS.contains(var.getName());
            if (isPerlInternal && !ShowPerlInternalVariableActionDelegate.getPreferenceValue()) {
                return false;
            }
            if (!isPerlInternal && !ShowGlobalVariableActionDelegate.getPreferenceValue()) {
                return false;
            }
        } else if (!ShowLocalVariableActionDelegate.getPreferenceValue()) {
            return false;
        }
        return true;
    }

    private boolean isTopFrame() {
        return this.topFrame;
    }

    private PerlDebugVar[] readTopFrameVars() throws DebugException {
        try {
            if (this.db.isDisposed()) {
                return new PerlDebugVar[0];
            }
            if (!this.db.isSuspended()) {
                return new PerlDebugVar[]{this.createSpecialVar("Warning", "Variables are only available in suspended mode")};
            }
            TokenVarParser varParser = new TokenVarParser(this.getDebugTarget(), PerlDebugPlugin.getDefault().getLog());
            ArrayList<PerlDebugVar> vars = new ArrayList<PerlDebugVar>();
            if (ShowLocalVariableActionDelegate.getPreferenceValue()) {
                String localVarsString = this.db.eval(DB_DUMP_LOCAL_VARS);
                if (localVarsString.startsWith(PADWALKER_ERROR)) {
                    vars.add(this.createSpecialVar("Error", "Install PadWalker Perl module to see local variables"));
                } else {
                    varParser.parseVars(localVarsString, 1, vars);
                }
            }
            String globalVarsString = this.db.eval(DB_DUMP_GLOBAL_VARS);
            varParser.parseVars(globalVarsString, 2, vars);
            return vars.toArray(new PerlDebugVar[vars.size()]);
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred while retrieving variables from the debugger process", (Throwable)e));
        }
    }

    private static String loadHelperScript(String scriptName) {
        try {
            return PerlDebugPlugin.getDefault().loadHelperScript(scriptName);
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
            return "print \"E\"";
        }
    }
}

