/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe2;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.CompactLocationNumbering;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ForwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.npe2.Condition;
import edu.umd.cs.findbugs.ba.npe2.Decision;
import edu.umd.cs.findbugs.ba.npe2.DefinitelyNullSet;
import edu.umd.cs.findbugs.ba.npe2.IfNullCondition;
import edu.umd.cs.findbugs.ba.npe2.NullnessValue;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitelyNullSetAnalysis
extends ForwardDataflowAnalysis<DefinitelyNullSet> {
    private ValueNumberDataflow vnaDataflow;
    private CompactLocationNumbering compactLocationNumbering;
    private Map<BasicBlock, Condition> conditionMap;
    private static final BitSet IFNULL_OPCODE_SET = new BitSet();
    private static final BitSet IFACMP_OPCODE_SET = new BitSet();
    private static final BitSet REFCMP_OPCODE_SET = new BitSet();
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$npe2$DefinitelyNullSetAnalysis;

    public DefinitelyNullSetAnalysis(DepthFirstSearch dfs, ValueNumberDataflow vnaDataflow, CompactLocationNumbering compactLocationNumbering) {
        super(dfs);
        this.vnaDataflow = vnaDataflow;
        this.compactLocationNumbering = compactLocationNumbering;
        this.conditionMap = new HashMap<BasicBlock, Condition>();
    }

    @Override
    public boolean isFactValid(DefinitelyNullSet fact) {
        return fact.isValid();
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, DefinitelyNullSet fact) throws DataflowAnalysisException {
        Condition condition;
        Location location = new Location(handle, basicBlock);
        ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(location);
        if (!vnaFrame.isValid()) {
            fact.setTop();
            return;
        }
        short opcode = handle.getInstruction().getOpcode();
        if (opcode == 1) {
            this.setTOS(vnaFrame, location, fact, NullnessValue.definitelyNullValue());
        } else if (opcode == 18 || opcode == 187) {
            this.setTOS(vnaFrame, location, fact, NullnessValue.definitelyNotNullValue());
        }
        if (handle == basicBlock.getLastInstruction() && REFCMP_OPCODE_SET.get(opcode) && (condition = this.getCondition(basicBlock)) != null) {
            condition.refresh((ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location), fact);
        }
    }

    private Condition getCondition(BasicBlock basicBlock) throws DataflowAnalysisException {
        Condition condition = this.conditionMap.get(basicBlock);
        if (condition == null) {
            Location location = new Location(basicBlock.getLastInstruction(), basicBlock);
            short opcode = basicBlock.getLastInstruction().getInstruction().getOpcode();
            if (!IFNULL_OPCODE_SET.get(opcode)) {
                if (IFACMP_OPCODE_SET.get(opcode)) {
                    return null;
                }
                return null;
            }
            condition = new IfNullCondition(location);
            this.conditionMap.put(basicBlock, condition);
        }
        return condition;
    }

    @Override
    public void edgeTransfer(Edge edge, DefinitelyNullSet fact) throws DataflowAnalysisException {
        if (!fact.isValid()) {
            return;
        }
        if (((BasicBlock)edge.getSource()).isEmpty()) {
            return;
        }
        Condition condition = this.getCondition((BasicBlock)edge.getSource());
        if (condition == null) {
            return;
        }
        Decision decision = condition.getDecision(edge);
        if (!decision.isFeasible()) {
            fact.setTop();
            return;
        }
        System.out.println(new StringBuffer().append("Setting ").append(condition.getValueNumber()).append(" to ").append(decision.getNullnessValue()).append(" on edge ").append(edge).toString());
        this.changeNullnessOfValue(condition.getValueNumber(), condition.getLocation(), fact, decision.getNullnessValue());
    }

    private void setTOS(ValueNumberFrame vnaFrame, Location location, DefinitelyNullSet fact, NullnessValue nullnessValue) throws DataflowAnalysisException {
        ValueNumber valueNumber = (ValueNumber)vnaFrame.getTopValue();
        this.changeNullnessOfValue(valueNumber, location, fact, nullnessValue);
    }

    private void changeNullnessOfValue(ValueNumber valueNumber, Location location, DefinitelyNullSet fact, NullnessValue nullnessValue) throws DataflowAnalysisException {
        fact.setNullnessValue(valueNumber, nullnessValue);
        if (fact.getNulllessValue(valueNumber) != nullnessValue) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void copy(DefinitelyNullSet source, DefinitelyNullSet dest) {
        dest.makeSameAs(source);
    }

    @Override
    public DefinitelyNullSet createFact() {
        return new DefinitelyNullSet(((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getNumValuesAllocated());
    }

    @Override
    public void initEntryFact(DefinitelyNullSet result) throws DataflowAnalysisException {
        result.clear();
    }

    @Override
    public void initResultFact(DefinitelyNullSet result) {
        result.setTop();
    }

    @Override
    public void makeFactTop(DefinitelyNullSet fact) {
        fact.setTop();
    }

    @Override
    public boolean isTop(DefinitelyNullSet fact) {
        return fact.isTop();
    }

    @Override
    public void meetInto(DefinitelyNullSet fact, Edge edge, DefinitelyNullSet result) throws DataflowAnalysisException {
        result.mergeWith(fact);
    }

    @Override
    public boolean same(DefinitelyNullSet fact1, DefinitelyNullSet fact2) {
        return fact1.equals(fact2);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$npe2$DefinitelyNullSetAnalysis == null ? (class$edu$umd$cs$findbugs$ba$npe2$DefinitelyNullSetAnalysis = DefinitelyNullSetAnalysis.class$("edu.umd.cs.findbugs.ba.npe2.DefinitelyNullSetAnalysis")) : class$edu$umd$cs$findbugs$ba$npe2$DefinitelyNullSetAnalysis).getName()).append(" <classfile>").toString());
            System.exit(1);
        }
        DataflowTestDriver<DefinitelyNullSet, DefinitelyNullSetAnalysis> driver = new DataflowTestDriver<DefinitelyNullSet, DefinitelyNullSetAnalysis>(){

            @Override
            public Dataflow<DefinitelyNullSet, DefinitelyNullSetAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                return classContext.getDefinitelyNullSetDataflow(method);
            }
        };
        driver.execute(args[0]);
    }

    @Override
    public /* synthetic */ boolean isFactValid(Object x0) {
        return this.isFactValid((DefinitelyNullSet)x0);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (DefinitelyNullSet)x2);
    }

    @Override
    public /* synthetic */ void edgeTransfer(Edge x0, Object x1) throws DataflowAnalysisException {
        this.edgeTransfer(x0, (DefinitelyNullSet)x1);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((DefinitelyNullSet)x0, x1, (DefinitelyNullSet)x2);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((DefinitelyNullSet)x0, (DefinitelyNullSet)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((DefinitelyNullSet)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((DefinitelyNullSet)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((DefinitelyNullSet)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((DefinitelyNullSet)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((DefinitelyNullSet)x0, (DefinitelyNullSet)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        IFNULL_OPCODE_SET.set(198);
        IFNULL_OPCODE_SET.set(199);
        IFACMP_OPCODE_SET.set(165);
        IFACMP_OPCODE_SET.set(166);
        REFCMP_OPCODE_SET.or(IFNULL_OPCODE_SET);
        REFCMP_OPCODE_SET.or(IFACMP_OPCODE_SET);
    }
}

