/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.cpcontainer;

import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jayasoft.ivyde.eclipse.IvyPlugin;

public class FileExtFilter
extends ViewerFilter {
    private String[] fTargetExtension;

    public FileExtFilter(String[] targetExtension) {
        this.fTargetExtension = targetExtension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        int i;
        if (element instanceof IFile && (i = 0) < this.fTargetExtension.length) {
            if (!((IFile)element).getName().toLowerCase(Locale.ENGLISH).endsWith("." + this.fTargetExtension[i])) return false;
            return true;
        }
        if (!(element instanceof IContainer)) return false;
        try {
            IResource[] resources = ((IContainer)element).members();
            int i2 = 0;
            while (true) {
                if (i2 >= resources.length) {
                    return false;
                }
                if (this.select(viewer, parent, resources[i2])) {
                    return true;
                }
                ++i2;
            }
        }
        catch (CoreException e) {
            IvyPlugin.log(e);
        }
        return false;
    }
}

