/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.common;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class UniversalPathTransformer {
    public static final String PLATFORM_PREFIX = "platform:/resource/";
    public static final String LOCATION_PREFIX = "file:/";
    private static String PROTOCOL_MARKER = ":";
    private static char PATH_SEPARATOR = (char)47;

    private boolean isPrefix(String uri, String prefix) {
        if (prefix.length() >= uri.length()) {
            return false;
        }
        return uri.substring(0, prefix.length()).equalsIgnoreCase(prefix);
    }

    public String toPath(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (this.isPrefix(str, PLATFORM_PREFIX)) {
            str = str.substring(PLATFORM_PREFIX.length() - 1);
        } else if (this.isPrefix(str, LOCATION_PREFIX)) {
            String s = str.substring(LOCATION_PREFIX.length());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(s));
            if (file != null) {
                str = file.getFullPath().makeAbsolute().toString();
            }
        }
        return str;
    }

    public String toPlatformPath(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (this.isPrefix(str, LOCATION_PREFIX)) {
            String s = str.substring(LOCATION_PREFIX.length());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(s));
            if (file != null) {
                str = PLATFORM_PREFIX + file.getFullPath().makeRelative();
            }
        } else if (str.indexOf(PROTOCOL_MARKER) == -1) {
            str = str.charAt(0) == PATH_SEPARATOR ? PLATFORM_PREFIX + str.substring(1) : PLATFORM_PREFIX + str;
        }
        return str;
    }

    public String toLocation(String str) {
        IFile file;
        if (str == null || str.length() == 0) {
            return str;
        }
        String s = str;
        if (this.isPrefix(s, PLATFORM_PREFIX)) {
            s = this.toPath(s);
        }
        if (s.indexOf(PROTOCOL_MARKER) == -1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(s))) != null) {
            str = file.getLocationURI().toString();
        }
        return str;
    }
}

