/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSchemaDirectiveAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.actions.SetInputToGraphView;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.INamedEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootContentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IFeedbackHandler;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IGraphElement;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.ADTDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.IADTUpdateCommand;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.SimpleDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures.FieldFigure;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNameCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.wst.xsd.ui.internal.design.editparts.CategoryEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.SelectionHandlesEditPolicyImpl;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.TopLevelComponentLabelCellEditorLocator;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.TopLevelNameDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.design.figures.HyperLinkLabel;
import org.eclipse.wst.xsd.ui.internal.design.layouts.FillLayout;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.utils.OpenOnSelectionHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDImportImpl;

public class TopLevelComponentEditPart
extends BaseEditPart
implements IFeedbackHandler,
INamedEditPart {
    protected Label label;
    protected Figure labelHolder = new Figure();
    protected SelectionHandlesEditPolicyImpl selectionHandlesEditPolicy;
    protected ADTDirectEditPolicy adtDirectEditPolicy = new ADTDirectEditPolicy();
    protected SimpleDirectEditPolicy simpleDirectEditPolicy = new SimpleDirectEditPolicy();
    protected boolean isReadOnly;
    protected boolean isSelected;
    private boolean doScroll = false;
    static boolean reselect = false;
    static /* synthetic */ Class class$0;

    protected IFigure createFigure() {
        Figure typeGroup = new Figure();
        typeGroup.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.labelHolder = new Figure();
        FillLayout fillLayout = new FillLayout();
        this.labelHolder.setLayoutManager((LayoutManager)fillLayout);
        typeGroup.add((IFigure)this.labelHolder);
        this.label = new HyperLinkLabel();
        this.label.setOpaque(true);
        this.label.setBorder((Border)new MarginBorder(0, 2, 2, 1));
        this.label.setForegroundColor(ColorConstants.black);
        this.labelHolder.add((IFigure)this.label);
        return typeGroup;
    }

    public void deactivate() {
        super.deactivate();
    }

    public void refreshVisuals() {
        XSDBaseAdapter adapter = (XSDBaseAdapter)this.getModel();
        if (adapter != null) {
            this.isReadOnly = adapter.isReadOnly();
            this.label.setForegroundColor(this.computeLabelColor());
            this.label.setText(adapter.getText());
            Image image = adapter.getImage();
            if (image != null) {
                this.label.setIcon(XSDCommonUIUtils.getUpdatedImage((XSDConcreteComponent)adapter.getTarget(), image, this.isReadOnly));
            }
        } else {
            this.label.setText(String.valueOf(Messages._UI_GRAPH_UNKNOWN_OBJECT) + this.getModel().getClass().getName());
        }
        if (reselect) {
            this.getViewer().select((EditPart)this);
            this.setReselect(false);
        }
    }

    public List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public EditPart doGetRelativeEditPart(EditPart editPart, int direction) {
        return ((BaseEditPart)this.getParent()).doGetRelativeEditPart(editPart, direction);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        SelectionHandlesEditPolicyImpl policy = new SelectionHandlesEditPolicyImpl();
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        SelectionEditPolicy feedBackSelectionEditPolicy = new SelectionEditPolicy(){

            protected void hideSelection() {
                EditPart editPart = this.getHost();
                if (editPart instanceof IFeedbackHandler) {
                    ((IFeedbackHandler)editPart).removeFeedback();
                }
            }

            protected void showSelection() {
                EditPart editPart = this.getHost();
                if (editPart instanceof IFeedbackHandler) {
                    ((IFeedbackHandler)editPart).addFeedback();
                }
            }
        };
        this.installEditPolicy("Selection Feedback", (EditPolicy)feedBackSelectionEditPolicy);
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.adtDirectEditPolicy);
    }

    public Color computeLabelColor() {
        Color color = ColorConstants.black;
        if (this.isSelected) {
            color = ColorConstants.black;
        } else if (this.isReadOnly) {
            color = ColorConstants.gray;
        }
        return color;
    }

    public void addFeedback() {
        this.isSelected = true;
        this.labelHolder.setBackgroundColor(FieldFigure.cellColor);
        this.label.setForegroundColor(this.computeLabelColor());
        if (this.doScroll) {
            CategoryEditPart categoryEP = (CategoryEditPart)this.getParent();
            categoryEP.scrollTo(this);
            this.setScroll(false);
        }
    }

    public void setScroll(boolean doScroll) {
        this.doScroll = doScroll;
    }

    public void removeFeedback() {
        this.isSelected = false;
        this.labelHolder.setBackgroundColor(null);
        this.label.setForegroundColor(this.computeLabelColor());
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            LocationRequest locationRequest;
            Point p;
            Object model = this.getModel();
            if (model instanceof IGraphElement) {
                LocationRequest locationRequest2;
                Point p2;
                if (((IGraphElement)model).isFocusAllowed() && request instanceof LocationRequest && this.hitTest((IFigure)this.labelHolder, p2 = (locationRequest2 = (LocationRequest)request).getLocation())) {
                    this.performDrillDownAction();
                }
            } else if (model instanceof XSDSchemaDirectiveAdapter && request instanceof LocationRequest && this.hitTest((IFigure)this.labelHolder, p = (locationRequest = (LocationRequest)request).getLocation())) {
                XSDSchemaDirective dir = (XSDSchemaDirective)((XSDSchemaDirectiveAdapter)model).getTarget();
                String schemaLocation = "";
                if (dir instanceof XSDImportImpl) {
                    ((XSDImportImpl)dir).importSchema();
                }
                if (dir.getResolvedSchema() != null && (schemaLocation = URIHelper.removePlatformResourceProtocol((String)dir.getResolvedSchema().getSchemaLocation())) != null) {
                    OpenOnSelectionHelper.openXSDEditor(schemaLocation);
                }
            }
        }
    }

    public boolean hitTest(IFigure target, Point location) {
        Rectangle b = target.getBounds().getCopy();
        target.translateToAbsolute((Translatable)b);
        return b.contains(location);
    }

    protected void performDrillDownAction() {
        Runnable runnable = new Runnable(){

            public void run() {
                EditPart editPart = ((AbstractEditPartViewer)TopLevelComponentEditPart.this.getViewer()).getRootEditPart().getContents();
                if (editPart instanceof RootContentEditPart) {
                    IEditorPart editorPart = TopLevelComponentEditPart.this.getEditorPart();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ActionRegistry registry = (ActionRegistry)editorPart.getAdapter((Class)clazz);
                    IAction action = registry.getAction((Object)SetInputToGraphView.ID);
                    action.run();
                }
            }
        };
        Display.getCurrent().asyncExec(runnable);
    }

    public void doEditName(boolean addFromDesign) {
        if (!addFromDesign) {
            return;
        }
        Notifier object = ((XSDBaseAdapter)this.getModel()).getTarget();
        if (object instanceof XSDNamedComponent) {
            Point p = this.label.getLocation();
            TopLevelNameDirectEditManager manager = new TopLevelNameDirectEditManager((GraphicalEditPart)this, new TopLevelComponentLabelCellEditorLocator(this, p), (XSDNamedComponent)object);
            NameUpdateCommandWrapper wrapper = new NameUpdateCommandWrapper();
            this.adtDirectEditPolicy.setUpdateCommand(wrapper);
            manager.show();
        }
    }

    public void setReselect(boolean state) {
        reselect = state;
    }

    public Label getNameLabelFigure() {
        return this.label;
    }

    public void performDirectEdit(Point cursorLocation) {
    }

    public void setSelected(int value) {
        if (this.doScroll) {
            this.setScroll(true);
        }
        super.setSelected(value);
    }

    class NameUpdateCommandWrapper
    extends Command
    implements IADTUpdateCommand {
        Command command;
        protected DirectEditRequest request;

        public NameUpdateCommandWrapper() {
            super(Messages._UI_ACTION_UPDATE_NAME);
        }

        public void setRequest(DirectEditRequest request) {
            this.request = request;
        }

        public void execute() {
            UpdateNameCommand command;
            XSDBaseAdapter adapter = (XSDBaseAdapter)TopLevelComponentEditPart.this.getModel();
            Object newValue = this.request.getCellEditor().getValue();
            if (newValue instanceof String && ((String)newValue).length() > 0 && (command = new UpdateNameCommand(Messages._UI_ACTION_UPDATE_NAME, (XSDNamedComponent)adapter.getTarget(), (String)newValue)) != null) {
                command.execute();
            }
        }
    }
}

