/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.style.java;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.style.java.JavaCodeScanner;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.Highlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class LineStyleProviderForJava
implements LineStyleProvider {
    private IDocument fDocument;
    private Highlighter fHighlighter;
    private boolean fIsInitialized = false;
    private PropertyChangeListener fPreferenceListener = new PropertyChangeListener();
    private JavaCodeScanner fScanner = new JavaCodeScanner();
    private HashMap fTextAttributes = null;

    private void addRange(Collection presentation, int offset, int length, TextAttribute attr) {
        String styleString = JSPUIPlugin.getDefault().getPreferenceStore().getString("jsp_content");
        String[] prefs = ColorHelper.unpackStylePreferences((String)styleString);
        Color bgColor = prefs != null && prefs.length == 3 && prefs[1].startsWith("#") && Display.getCurrent() != null ? new Color((Device)Display.getCurrent(), ColorHelper.toRGB((String)prefs[1])) : attr.getBackground();
        presentation.add(new StyleRange(offset, length, attr.getForeground(), bgColor, attr.getStyle()));
    }

    private void addTextAttribute(String colorKey) {
        String prefString;
        String[] stylePrefs;
        if (this.getColorPreferences() != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = this.getColorPreferences().getString(colorKey)))) != null) {
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            boolean bold = Boolean.valueOf(stylePrefs[2]);
            this.getTextAttributes().put(colorKey, this.createTextAttribute(foreground, background, bold));
        }
    }

    private void addJavaTextAttribute(String colorKey) {
        IPreferenceStore store = this.getJavaColorPreferences();
        if (store != null && colorKey != null) {
            TextAttribute ta = null;
            if (colorKey == "keyword") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_keyword");
                boolean bold = store.getBoolean("java_keyword_bold");
                boolean italics = store.getBoolean("java_keyword_italic");
                ta = this.createTextAttribute(foreground, null, bold, italics);
            } else if (colorKey == "string") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_string");
                boolean bold = store.getBoolean("java_string_bold");
                boolean italics = store.getBoolean("java_string_italic");
                ta = this.createTextAttribute(foreground, null, bold, italics);
            } else if (colorKey == "single_line_comment") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_single_line_comment");
                boolean bold = store.getBoolean("java_single_line_comment_bold");
                boolean italics = store.getBoolean("java_single_line_comment_italic");
                ta = this.createTextAttribute(foreground, null, bold, italics);
            } else if (colorKey == "default") {
                RGB foreground = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_default");
                boolean bold = store.getBoolean("java_default_bold");
                boolean italics = store.getBoolean("java_default_italic");
                ta = this.createTextAttribute(foreground, null, bold, italics);
            }
            if (ta != null) {
                this.getTextAttributes().put(colorKey, ta);
                this.fScanner.setTokenData(colorKey, ta);
            }
        }
    }

    private TextAttribute createTextAttribute(RGB foreground, RGB background, boolean bold) {
        return new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : null, background != null ? EditorUtility.getColor((RGB)background) : null, bold ? 1 : 0);
    }

    private TextAttribute createTextAttribute(RGB foreground, RGB background, boolean bold, boolean italics) {
        int style;
        int n = style = bold ? 1 : 0;
        if (italics) {
            style |= 2;
        }
        return new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : null, background != null ? EditorUtility.getColor((RGB)background) : null, style);
    }

    private HashMap getTextAttributes() {
        if (this.fTextAttributes == null) {
            this.fTextAttributes = new HashMap();
            this.loadColors();
        }
        return this.fTextAttributes;
    }

    private TextAttribute getTokenTextAttribute(IToken token) {
        TextAttribute ta = null;
        Object data = token.getData();
        ta = data instanceof TextAttribute ? (TextAttribute)data : (TextAttribute)this.getTextAttributes().get("default");
        return ta;
    }

    public void init(IStructuredDocument document, Highlighter highlighter) {
        this.fDocument = document;
        this.fHighlighter = highlighter;
        if (this.fIsInitialized) {
            return;
        }
        this.registerPreferenceListener();
        this.fIsInitialized = true;
    }

    private void loadColors() {
        this.addTextAttribute("SCRIPT_AREA_BORDER");
        this.addTextAttribute("tagAttributeName");
        this.addTextAttribute("tagAttributeValue");
        this.addJavaTextAttribute("keyword");
        this.addJavaTextAttribute("string");
        this.addJavaTextAttribute("single_line_comment");
        this.addJavaTextAttribute("default");
        this.fScanner.initializeRules();
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String styleKey = null;
        String javaStyleKey = null;
        if (event != null) {
            String prefKey = event.getProperty();
            if ("SCRIPT_AREA_BORDER".equals(prefKey)) {
                styleKey = "SCRIPT_AREA_BORDER";
            } else if ("tagAttributeName".equals(prefKey)) {
                styleKey = "tagAttributeName";
            } else if ("tagAttributeValue".equals(prefKey)) {
                styleKey = "tagAttributeValue";
            } else if ("java_keyword".equals(prefKey) || "java_keyword_bold".equals(prefKey) || "java_keyword_italic".equals(prefKey)) {
                javaStyleKey = "keyword";
            } else if ("java_string".equals(prefKey) || "java_string_bold".equals(prefKey) || "java_string_italic".equals(prefKey)) {
                javaStyleKey = "string";
            } else if ("java_single_line_comment".equals(prefKey) || "java_single_line_comment_bold".equals(prefKey) || "java_single_line_comment_italic".equals(prefKey)) {
                javaStyleKey = "single_line_comment";
            } else if ("java_default".equals(prefKey) || "java_default_bold".equals(prefKey) || "java_default_italic".equals(prefKey)) {
                javaStyleKey = "default";
            }
        }
        if (styleKey != null) {
            this.addTextAttribute(styleKey);
        }
        if (javaStyleKey != null) {
            this.addJavaTextAttribute(javaStyleKey);
            this.fScanner.initializeRules();
        }
        if (styleKey != null || javaStyleKey != null) {
            this.fHighlighter.refreshDisplay();
        }
    }

    public boolean prepareRegions(ITypedRegion typedRegion, int ssssrequestedStart, int ssssrequestedLength, Collection holdResults) {
        boolean result = true;
        try {
            int offsetAdjustment = typedRegion.getOffset();
            String content = this.fDocument.get(typedRegion.getOffset(), typedRegion.getLength());
            Document document = new Document(content);
            int lastStart = 0;
            int length = 0;
            IToken lastToken = Token.UNDEFINED;
            int remainingLength = typedRegion.getLength();
            this.fScanner.setRange((IDocument)document, lastStart, remainingLength);
            while (true) {
                IToken token;
                if ((token = this.fScanner.nextToken()).isEOF()) {
                    if (!lastToken.isUndefined() && length != 0) {
                        this.addRange(holdResults, lastStart + offsetAdjustment, length, this.getTokenTextAttribute(lastToken));
                    }
                    break;
                }
                if (token.isWhitespace()) {
                    length += this.fScanner.getTokenLength();
                    continue;
                }
                if (lastToken.isUndefined()) {
                    lastToken = token;
                    length += this.fScanner.getTokenLength();
                    continue;
                }
                if (token != lastToken) {
                    this.addRange(holdResults, lastStart + offsetAdjustment, length, this.getTokenTextAttribute(lastToken));
                    lastToken = token;
                    lastStart = this.fScanner.getTokenOffset();
                    length = this.fScanner.getTokenLength();
                    continue;
                }
                length += this.fScanner.getTokenLength();
            }
        }
        catch (BadLocationException badLocationException) {
            result = false;
        }
        return result;
    }

    private void registerPreferenceListener() {
        this.getColorPreferences().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.getJavaColorPreferences().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public void release() {
        this.unregisterPreferenceManager();
        if (this.fTextAttributes != null) {
            this.fTextAttributes.clear();
            this.fTextAttributes = null;
        }
    }

    private void unregisterPreferenceManager() {
        this.getColorPreferences().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.getJavaColorPreferences().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    private IPreferenceStore getColorPreferences() {
        return JSPUIPlugin.getDefault().getPreferenceStore();
    }

    private IPreferenceStore getJavaColorPreferences() {
        return PreferenceConstants.getPreferenceStore();
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            LineStyleProviderForJava.this.handlePropertyChange(event);
        }
    }
}

