/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.sqleditor.internal.actions;

import java.util.ResourceBundle;

import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditor;

/**
 * This class implements the "Disconnect" action for the SQL Editor.
 * 
 * @see org.eclipse.wst.rdb.sqleditor.internal.SQLEditorActionContributor
 * @see org.eclipse.ui.texteditor.ResourceAction
 */
public class SQLDisconnectAction extends ResourceAction {

    private SQLEditor fSQLEditor;
    
    /**
     * Creates an instance of this class using the given resource bundle
     * and prefix of a set of resources within the bundle.
     * 
     * @param bundle the resource bundle to use
     * @param prefix the resource prefix to use
     */
    public SQLDisconnectAction( ResourceBundle bundle, String prefix ) {
        super( bundle, prefix );
    }

    /**
     * Gets the SQLEditor instance associated with this action.
     * 
     * @return the SQLEditor instance for this action
     */
    public SQLEditor getSQLEditor() {
        return fSQLEditor;
    }

    /**
     * Runs this action.  Disconnects the editor from the currently connected database.
     * 
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run() {
        SQLEditor editor = getSQLEditor();
        if (editor != null) {
            ConnectionInfo connInfo = editor.getConnectionInfo();
            if (connInfo != null) {
                firePropertyChange( SQLConnectAction.CONNECTION, connInfo, null );
            }
        }
    }

    /**
     * Sets the SQLEditor instance associated with this action to the given object.
     * 
     * @param sqlEditor the SQLEditor instance for this action
     */
    public void setSQLEditor( SQLEditor sqlEditor ) {
        fSQLEditor = sqlEditor;
    }

} // end class
