/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.internal.core.IRepositoryProviderListener;
import org.eclipse.team.internal.core.RepositoryProviderManager;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;

public abstract class ChangeTracker
implements IResourceChangeListener,
IRepositoryProviderListener {
    private Map trackedProjects = new HashMap();
    private boolean disposed;

    public void start() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        RepositoryProviderManager.getInstance().addListener(this);
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < allProjects.length) {
            IProject project = allProjects[i];
            if (this.isProjectOfInterest(project)) {
                this.trackProject(project);
            }
            ++i;
        }
    }

    public void dispose() {
        this.disposed = true;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        RepositoryProviderManager.getInstance().removeListener(this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.disposed) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        IResourceDelta[] projectDeltas = delta.getAffectedChildren(7);
        int i = 0;
        while (i < projectDeltas.length) {
            IResourceDelta projectDelta = projectDeltas[i];
            IResource resource = projectDelta.getResource();
            if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                if (this.isProjectOfInterest(project)) {
                    if (this.isProjectTracked(project)) {
                        IResource[] resources = this.getProjectChanges(project, projectDelta);
                        if (resources.length > 0) {
                            this.handleChanges(project, resources);
                        }
                    } else {
                        this.trackProject(project);
                    }
                } else {
                    this.stopTrackingProject(project);
                }
            }
            ++i;
        }
    }

    private IResource[] getProjectChanges(IProject project, IResourceDelta projectDelta) {
        final ArrayList result = new ArrayList();
        try {
            projectDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (ChangeTracker.this.isResourceOfInterest(delta.getResource()) & ChangeTracker.this.isChangeOfInterest(delta)) {
                        result.add(delta.getResource());
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            TeamPlugin.log(e);
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected boolean isChangeOfInterest(IResourceDelta delta) {
        return (delta.getKind() & 7) > 0;
    }

    protected void stopTrackingProject(IProject project) {
        this.trackedProjects.remove(project);
    }

    protected final boolean isProjectTracked(IProject project) {
        return this.trackedProjects.containsKey(project);
    }

    protected boolean isProjectOfInterest(IProject project) {
        return project.isAccessible();
    }

    public void providerMapped(RepositoryProvider provider) {
        if (this.disposed) {
            return;
        }
        if (this.isProjectOfInterest(provider.getProject())) {
            this.trackProject(provider.getProject());
        }
    }

    public void providerUnmapped(IProject project) {
        if (this.disposed) {
            return;
        }
        this.stopTrackingProject(project);
    }

    protected abstract boolean isResourceOfInterest(IResource var1);

    protected abstract void handleChanges(IProject var1, IResource[] var2);

    protected abstract void handleProjectChange(IProject var1);

    protected final boolean trackProject(IProject project) {
        if (RepositoryProvider.isShared(project)) {
            try {
                ActiveChangeSetManager collector;
                RepositoryProviderType type;
                String currentId = project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
                if (currentId != null && (type = RepositoryProviderType.getProviderType(currentId)) != null && (collector = this.getCollector(type)) != null) {
                    this.trackedProjects.put(project, collector);
                    this.projectTracked(project);
                    return true;
                }
            }
            catch (CoreException e) {
                TeamPlugin.log(e);
            }
        }
        return false;
    }

    private ActiveChangeSetManager getCollector(RepositoryProviderType type) {
        IAdaptable adaptable;
        Object o;
        if (type instanceof IAdaptable && (o = (adaptable = (IAdaptable)type).getAdapter(ActiveChangeSetManager.class)) instanceof ActiveChangeSetManager) {
            return (ActiveChangeSetManager)o;
        }
        return null;
    }

    protected void projectTracked(IProject project) {
        this.handleProjectChange(project);
    }

    protected void groupAsSet(IProject project, String name, IFile[] files) throws CoreException {
        ActiveChangeSetManager collector = this.getCollector(project);
        if (collector != null) {
            ActiveChangeSet set = collector.getSet(name);
            if (set == null) {
                set = collector.createSet(name, files);
                set.setUserCreated(false);
                collector.add(set);
            } else {
                set.setUserCreated(false);
                set.add((IResource[])files);
            }
        }
    }

    private ActiveChangeSetManager getCollector(IProject project) {
        return (ActiveChangeSetManager)this.trackedProjects.get(project);
    }

    protected boolean isModified(IFile file) throws CoreException {
        ActiveChangeSetManager collector = this.getCollector(file.getProject());
        if (collector != null) {
            return collector.isModified(file);
        }
        return false;
    }
}

