/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.MinimalState;
import org.eclipse.pde.internal.core.PDEAuxiliaryState;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.w3c.dom.Node;

public class PDEState
extends MinimalState {
    private PDEExtensionRegistry fExtensionRegistry;
    private PDEAuxiliaryState fAuxiliaryState;
    private Map fTargetModels = new HashMap();
    private ArrayList fWorkspaceModels = new ArrayList();
    private boolean fCombined;
    private long fTargetTimestamp;
    private boolean fNewState;

    public PDEState(URL[] urls, boolean resolve, IProgressMonitor monitor) {
        this(new URL[0], urls, resolve, monitor);
    }

    public PDEState(URL[] workspace, URL[] target, boolean resolve, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        this.fExtensionRegistry = new PDEExtensionRegistry();
        this.fAuxiliaryState = new PDEAuxiliaryState();
        if (resolve) {
            this.readTargetState(target, monitor);
        } else {
            this.createNewTargetState(resolve, target, monitor);
            this.fExtensionRegistry.createExtensionDocument(this.fState);
        }
        this.createTargetModels();
        if (resolve && workspace.length > 0 && !this.fNewState && !"true".equals(System.getProperty("pde.nocache"))) {
            this.readWorkspaceState(workspace);
        }
        this.fExtensionRegistry.clear();
        this.fAuxiliaryState.clear();
        if (DEBUG) {
            System.out.println("Time to create state: " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private void readTargetState(URL[] urls, IProgressMonitor monitor) {
        this.fTargetTimestamp = this.computeTimestamp(urls);
        File dir = new File(DIR, String.valueOf(Long.toString(this.fTargetTimestamp)) + ".target");
        this.fState = this.readStateCache(dir);
        if (this.fState == null || !this.fAuxiliaryState.readPluginInfoCache(dir)) {
            this.createNewTargetState(true, urls, monitor);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.fAuxiliaryState.savePluginInfo(dir);
            this.resolveState(false);
            this.saveState(dir);
        } else {
            this.fState.setResolver(Platform.getPlatformAdmin().getResolver());
            this.fId = this.fState.getBundles().length;
        }
        if (!this.fExtensionRegistry.readExtensionsCache(dir)) {
            this.fExtensionRegistry.saveExtensions(this.fState, dir);
        }
    }

    private void createNewTargetState(boolean resolve, URL[] urls, IProgressMonitor monitor) {
        this.fState = stateObjectFactory.createState(resolve);
        monitor.beginTask("", urls.length);
        int i = 0;
        while (i < urls.length) {
            File file = new File(urls[i].getFile());
            try {
                try {
                    monitor.subTask(file.getName());
                    this.addBundle(file, -1L);
                }
                catch (PluginConversionException pluginConversionException) {
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {
                    PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", 4, "Invalid manifest format at " + file.getAbsolutePath(), null));
                }
            }
            finally {
                monitor.worked(1);
            }
            ++i;
        }
        this.fNewState = true;
    }

    protected void addAuxiliaryData(BundleDescription desc, Dictionary manifest, boolean hasBundleStructure) {
        this.fAuxiliaryState.addAuxiliaryData(desc, manifest, hasBundleStructure);
    }

    private void createTargetModels() {
        BundleDescription[] bundleDescriptions = this.fState.getBundles();
        int i = 0;
        while (i < bundleDescriptions.length) {
            boolean add = true;
            if (!bundleDescriptions[i].isResolved()) {
                ResolverError[] error = this.fState.getResolverErrors(bundleDescriptions[i]);
                int j = 0;
                while (j < error.length) {
                    if (error[j].getType() == 8) {
                        add = false;
                        break;
                    }
                    ++j;
                }
            }
            if (add) {
                BundleDescription desc = bundleDescriptions[i];
                this.fTargetModels.put(desc.getSymbolicName(), this.createExternalModel(desc));
            }
            ++i;
        }
    }

    private void readWorkspaceState(URL[] urls) {
        long workspace = this.computeTimestamp(urls);
        File dir = new File(DIR, String.valueOf(Long.toString(workspace)) + ".workspace");
        State localState = this.readStateCache(dir);
        boolean bl = this.fCombined = localState != null && this.fAuxiliaryState.readPluginInfoCache(dir) && this.fExtensionRegistry.readExtensionsCache(dir);
        if (this.fCombined) {
            BundleDescription[] bundles = localState.getBundles();
            int i = 0;
            while (i < bundles.length) {
                BundleDescription desc = bundles[i];
                String id = desc.getSymbolicName();
                BundleDescription[] conflicts = this.fState.getBundles(id);
                int j = 0;
                while (j < conflicts.length) {
                    this.fState.removeBundle(conflicts[j]);
                    ++j;
                }
                BundleDescription newbundle = stateObjectFactory.createBundleDescription(desc);
                IPluginModelBase model = this.createWorkspaceModel(newbundle);
                if (model != null && this.fState.addBundle(newbundle)) {
                    this.fId = Math.max(this.fId, newbundle.getBundleId());
                    this.fWorkspaceModels.add(model);
                }
                ++i;
            }
            this.fId = Math.max(this.fId, (long)this.fState.getBundles().length);
            this.fState.resolve(false);
        }
    }

    public boolean isCombined() {
        return this.fCombined;
    }

    private State readStateCache(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            try {
                return stateObjectFactory.readState(dir);
            }
            catch (IllegalStateException e) {
                PDECore.log(e);
            }
            catch (FileNotFoundException e) {
                PDECore.log(e);
            }
            catch (IOException e) {
                PDECore.log(e);
            }
        }
        return null;
    }

    private long computeTimestamp(URL[] urls) {
        long timestamp = 0L;
        int i = 0;
        while (i < urls.length) {
            File file = new File(urls[i].getFile());
            if (file.exists()) {
                if (file.isFile()) {
                    timestamp ^= file.lastModified();
                } else {
                    File manifest = new File(file, "META-INF/MANIFEST.MF");
                    if (manifest.exists()) {
                        timestamp ^= manifest.lastModified();
                    }
                    if ((manifest = new File(file, "plugin.xml")).exists()) {
                        timestamp ^= manifest.lastModified();
                    }
                    if ((manifest = new File(file, "fragment.xml")).exists()) {
                        timestamp ^= manifest.lastModified();
                    }
                }
                timestamp ^= (long)file.getAbsolutePath().hashCode();
            }
            ++i;
        }
        return timestamp;
    }

    private IPluginModelBase createWorkspaceModel(BundleDescription desc) {
        String projectName = this.fAuxiliaryState.getProject(desc.getBundleId());
        IProject project = PDECore.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            return null;
        }
        if (WorkspaceModelManager.hasBundleManifest(project)) {
            BundlePluginModelBase model = null;
            model = desc.getHost() == null ? new BundlePluginModel() : new BundleFragmentModel();
            model.setEnabled(true);
            WorkspaceBundleModel bundle = new WorkspaceBundleModel(project.getFile("META-INF/MANIFEST.MF"));
            bundle.load(desc, this);
            model.setBundleDescription(desc);
            model.setBundleModel(bundle);
            String filename = desc.getHost() == null ? "plugin.xml" : "fragment.xml";
            IFile file = project.getFile(filename);
            if (file.exists()) {
                WorkspaceExtensionsModel extensions = new WorkspaceExtensionsModel(file);
                extensions.load(desc, this);
                extensions.setBundleModel(model);
                model.setExtensionsModel(extensions);
            }
            return model;
        }
        WorkspacePluginModelBase model = null;
        model = desc.getHost() == null ? new WorkspacePluginModel(project.getFile("plugin.xml"), true) : new WorkspaceFragmentModel(project.getFile("fragment.xml"), true);
        model.load(desc, this);
        model.setBundleDescription(desc);
        return model;
    }

    private IPluginModelBase createExternalModel(BundleDescription desc) {
        ExternalPluginModelBase model = null;
        model = desc.getHost() == null ? new ExternalPluginModel() : new ExternalFragmentModel();
        model.load(desc, this);
        model.setBundleDescription(desc);
        return model;
    }

    public IPluginModelBase[] getTargetModels() {
        return this.fTargetModels.values().toArray(new IPluginModelBase[this.fTargetModels.size()]);
    }

    public IPluginModelBase[] getWorkspaceModels() {
        return this.fWorkspaceModels.toArray(new IPluginModelBase[this.fWorkspaceModels.size()]);
    }

    public void shutdown() {
        IPluginModelBase[] models = PDECore.getDefault().getModelManager().getWorkspaceModels();
        long timestamp = 0L;
        if (!"true".equals(System.getProperty("pde.nocache")) && this.shouldSaveState(models)) {
            timestamp = this.computeTimestamp(models);
            File dir = new File(DIR, String.valueOf(Long.toString(timestamp)) + ".workspace");
            State state = stateObjectFactory.createState(false);
            int i = 0;
            while (i < models.length) {
                state.addBundle(models[i].getBundleDescription());
                ++i;
            }
            this.saveState(state, dir);
            PDEAuxiliaryState.writePluginInfo(models, dir);
            PDEExtensionRegistry.writeExtensions(models, dir);
        }
        this.clearStaleStates(".target", this.fTargetTimestamp);
        this.clearStaleStates(".workspace", timestamp);
        this.clearStaleStates(".cache", 0L);
    }

    private long computeTimestamp(IPluginModelBase[] models) {
        URL[] urls = new URL[models.length];
        int i = 0;
        while (i < models.length) {
            try {
                IProject project = models[i].getUnderlyingResource().getProject();
                urls[i] = new File(project.getLocation().toString()).toURL();
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        return this.computeTimestamp(urls);
    }

    private boolean shouldSaveState(IPluginModelBase[] models) {
        int i = 0;
        while (i < models.length) {
            String id = models[i].getPluginBase().getId();
            if (id == null || id.trim().length() == 0 || !models[i].isLoaded() || !models[i].isInSync() || models[i].getBundleDescription() == null) {
                return false;
            }
            ++i;
        }
        return models.length > 0;
    }

    private void clearStaleStates(String extension, long latest) {
        File dir = new File(PDECore.getDefault().getStateLocation().toOSString());
        File[] children = dir.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                String name;
                File child = children[i];
                if (child.isDirectory() && (name = child.getName()).endsWith(extension) && name.length() > extension.length() && !name.equals(String.valueOf(Long.toString(latest)) + extension)) {
                    CoreUtility.deleteContent(child);
                }
                ++i;
            }
        }
    }

    public Node[] getExtensions(long bundleID) {
        return this.fExtensionRegistry.getExtensions(bundleID);
    }

    public Node[] getExtensionPoints(long bundleID) {
        return this.fExtensionRegistry.getExtensionPoints(bundleID);
    }

    public Node[] getAllExtensions(long bundleID) {
        return this.fExtensionRegistry.getAllExtensions(bundleID);
    }

    public String getClassName(long bundleID) {
        return this.fAuxiliaryState.getClassName(bundleID);
    }

    public boolean hasExtensibleAPI(long bundleID) {
        return this.fAuxiliaryState.hasExtensibleAPI(bundleID);
    }

    public boolean isPatchFragment(long bundleID) {
        return this.fAuxiliaryState.isPatchFragment(bundleID);
    }

    public boolean hasBundleStructure(long bundleID) {
        return this.fAuxiliaryState.hasBundleStructure(bundleID);
    }

    public String getSchemaVersion(long bundleID) {
        return this.fExtensionRegistry.getSchemaVersion(bundleID);
    }

    public String getPluginName(long bundleID) {
        return this.fAuxiliaryState.getPluginName(bundleID);
    }

    public String getProviderName(long bundleID) {
        return this.fAuxiliaryState.getProviderName(bundleID);
    }

    public String[] getLibraryNames(long bundleID) {
        return this.fAuxiliaryState.getLibraryNames(bundleID);
    }

    public String getBundleLocalization(long bundleID) {
        return this.fAuxiliaryState.getBundleLocalization(bundleID);
    }

    public String getProject(long bundleID) {
        return this.fAuxiliaryState.getProject(bundleID);
    }
}

