/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

class AdapterFactoryProxy
implements IAdapterFactory,
IAdapterFactoryExt {
    private IConfigurationElement element;
    private String ownerId;
    private IAdapterFactory factory;
    private boolean factoryLoaded = false;

    AdapterFactoryProxy() {
    }

    public static AdapterFactoryProxy createProxy(IConfigurationElement element) {
        AdapterFactoryProxy result = new AdapterFactoryProxy();
        result.element = element;
        result.ownerId = element.getDeclaringExtension().getUniqueIdentifier();
        if ("factory".equals(element.getName())) {
            return result;
        }
        result.logError();
        return null;
    }

    String getAdaptableType() {
        String result = this.element.getAttribute("adaptableType");
        if (result != null) {
            return result;
        }
        this.logError();
        return "";
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!this.factoryLoaded) {
            this.loadFactory(false);
        }
        return this.factory == null ? null : this.factory.getAdapter(adaptableObject, adapterType);
    }

    public Class[] getAdapterList() {
        if (!this.factoryLoaded) {
            this.loadFactory(false);
        }
        return this.factory == null ? null : this.factory.getAdapterList();
    }

    public String[] getAdapterNames() {
        IConfigurationElement[] children = this.element.getChildren();
        ArrayList<String> adapters = new ArrayList<String>(children.length);
        int i = 0;
        while (i < children.length) {
            String type;
            if ("adapter".equals(children[i].getName()) && (type = children[i].getAttribute("type")) != null) {
                adapters.add(type);
            }
            ++i;
        }
        if (adapters.isEmpty()) {
            this.logError();
        }
        return adapters.toArray(new String[adapters.size()]);
    }

    IExtension getExtension() {
        return this.element.getDeclaringExtension();
    }

    String getOwnerId() {
        return this.ownerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAdapterFactory loadFactory(boolean force) {
        AdapterFactoryProxy adapterFactoryProxy = this;
        synchronized (adapterFactoryProxy) {
            block7: {
                if (this.factory != null || this.factoryLoaded) {
                    return this.factory;
                }
                String bundleId = this.element.getContributor().getName();
                if (force || Platform.getBundle(bundleId).getState() == 32) break block7;
                return null;
            }
            this.factoryLoaded = true;
        }
        try {
            this.factory = (IAdapterFactory)this.element.createExecutableExtension("class");
        }
        catch (CoreException e) {
            InternalPlatform.getDefault().log(e.getStatus());
        }
        return this.factory;
    }

    private void logError() {
        String msg = NLS.bind((String)Messages.adapters_badAdapterFactory, (Object)this.element.getContributor().getName());
        InternalPlatform.getDefault().log((IStatus)new Status(4, "org.eclipse.core.runtime", 1, msg, null));
    }
}

