/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class WorkingSetSelectionArea
extends DialogArea {
    private Button noWorkingSetButton;
    private Button workingSetButton;
    private Combo mruList;
    private Button selectButton;
    private IWorkingSet workingSet;
    private IWorkingSet oldWorkingSet;
    private String noWorkingSetText;
    private String workingSetText;
    private static final String USE_WORKING_SET = "UseWorkingSet";
    public static final String SELECTED_WORKING_SET = "SelectedWorkingSet";
    private IPropertyChangeListener workingSetChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            Object newValue = event.getNewValue();
            if ("workingSetNameChange".equals(property) && newValue instanceof IWorkingSet) {
                String newName = ((IWorkingSet)newValue).getName();
                int count = WorkingSetSelectionArea.this.mruList.getItemCount();
                int i = 0;
                while (i < count) {
                    String item = WorkingSetSelectionArea.this.mruList.getItem(i);
                    IWorkingSet workingSet = (IWorkingSet)WorkingSetSelectionArea.this.mruList.getData(item);
                    if (workingSet == newValue) {
                        boolean isTopItem = WorkingSetSelectionArea.this.mruList.getData(WorkingSetSelectionArea.this.mruList.getText()) == workingSet;
                        WorkingSetSelectionArea.this.mruList.remove(i);
                        WorkingSetSelectionArea.this.mruList.add(newName, i);
                        WorkingSetSelectionArea.this.mruList.setData(newName, (Object)workingSet);
                        if (!isTopItem) break;
                        WorkingSetSelectionArea.this.mruList.setText(newName);
                        break;
                    }
                    ++i;
                }
            }
        }
    };
    private final IDialogSettings settings;
    private final Shell shell;

    public WorkingSetSelectionArea(Shell shell, String noWorkingSetText, String workingSetText, IDialogSettings settings) {
        this.shell = shell;
        this.noWorkingSetText = noWorkingSetText;
        this.workingSetText = workingSetText;
        this.settings = settings;
    }

    public void createArea(Composite parent) {
        Dialog.applyDialogFont((Control)parent);
        Composite composite = this.createComposite(parent, 2, false);
        this.initializeDialogUnits((Control)composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.noWorkingSetButton = this.createRadioButton(composite, this.noWorkingSetText, 2);
        this.workingSetButton = this.createRadioButton(composite, this.workingSetText, 2);
        this.workingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetSelectionArea.this.handleWorkingSetButtonSelection();
            }
        });
        boolean useWorkingSet = false;
        if (this.settings != null) {
            useWorkingSet = this.settings.getBoolean(USE_WORKING_SET);
        }
        this.noWorkingSetButton.setSelection(!useWorkingSet);
        this.workingSetButton.setSelection(useWorkingSet);
        this.mruList = new Combo(composite, 12);
        GridData data = new GridData(4, 0x1000000, true, true);
        data.horizontalIndent = 15;
        this.mruList.setLayoutData((Object)data);
        this.selectButton = this.createButton(composite, CVSUIMessages.WorkingSetSelectionArea_workingSetOther, 256);
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkingSetSelectionArea.this.handleWorkingSetSelection();
            }
        });
        this.initializeMru();
        this.initializeWorkingSet();
        this.mruList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetSelectionArea.this.handleMruSelection();
            }
        });
    }

    private void handleMruSelection() {
        String selectedWorkingSet = this.mruList.getText();
        this.oldWorkingSet = this.workingSet;
        this.workingSet = (IWorkingSet)this.mruList.getData(selectedWorkingSet);
        if (this.settings != null) {
            this.settings.put(SELECTED_WORKING_SET, selectedWorkingSet);
        }
        this.handleWorkingSetChange();
    }

    private void handleWorkingSetSelection() {
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(this.shell, false);
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.getWorkingSet(this.mruList.getText());
        if (workingSet != null) {
            dialog.setSelection(new IWorkingSet[]{workingSet});
        }
        workingSetManager.addPropertyChangeListener(this.workingSetChangeListener);
        if (dialog.open() == 0) {
            IWorkingSet[] result = dialog.getSelection();
            if (result != null && result.length > 0) {
                workingSet = result[0];
                String workingSetName = workingSet.getName();
                if (this.mruList.indexOf(workingSetName) != -1) {
                    this.mruList.remove(workingSetName);
                }
                this.mruList.add(workingSetName, 0);
                this.mruList.setText(workingSetName);
                this.mruList.setData(workingSetName, (Object)workingSet);
                this.handleMruSelection();
            } else {
                workingSet = null;
            }
            String[] mruNames = this.mruList.getItems();
            int i = 0;
            while (i < mruNames.length) {
                if (workingSetManager.getWorkingSet(mruNames[i]) == null) {
                    this.mruList.remove(mruNames[i]);
                }
                ++i;
            }
        }
        workingSetManager.removePropertyChangeListener(this.workingSetChangeListener);
    }

    private void handleWorkingSetButtonSelection() {
        boolean useWorkingSet = this.workingSetButton.getSelection();
        if (this.settings != null) {
            this.settings.put(USE_WORKING_SET, useWorkingSet);
        }
        this.mruList.setEnabled(useWorkingSet);
        this.selectButton.setEnabled(useWorkingSet);
        if (useWorkingSet && this.mruList.getSelectionIndex() >= 0) {
            this.handleMruSelection();
        } else if (!useWorkingSet) {
            this.handleDeselection();
        }
    }

    private void handleDeselection() {
        this.oldWorkingSet = this.workingSet;
        this.workingSet = null;
        this.handleWorkingSetChange();
    }

    private void handleWorkingSetChange() {
        this.firePropertyChangeChange(SELECTED_WORKING_SET, this.oldWorkingSet, this.workingSet);
    }

    private void initializeMru() {
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            String workingSetName = workingSets[i].getName();
            this.mruList.add(workingSetName);
            this.mruList.setData(workingSetName, (Object)workingSets[i]);
            ++i;
        }
        if (workingSets.length > 0) {
            this.mruList.setText(workingSets[0].getName());
        }
    }

    private void initializeWorkingSet() {
        IWorkingSet mruSet;
        if (this.workingSet == null && this.settings != null && this.settings.getBoolean(USE_WORKING_SET) && (mruSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(this.settings.get(SELECTED_WORKING_SET))) != null) {
            this.setWorkingSet(mruSet);
            return;
        }
        this.workingSetButton.setSelection(this.workingSet != null);
        this.handleWorkingSetButtonSelection();
        if (this.workingSet != null && this.mruList.indexOf(this.workingSet.getName()) != -1) {
            this.mruList.setText(this.workingSet.getName());
        }
        this.handleWorkingSetChange();
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.oldWorkingSet = this.workingSet;
        this.workingSet = workingSet;
        if (this.workingSetButton != null && this.mruList != null) {
            this.initializeWorkingSet();
        }
    }
}

