/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class UpdatedHandler
extends ResponseHandler {
    private int handlerType;
    public static final int HANDLE_UPDATED = 1;
    public static final int HANDLE_MERGED = 2;
    public static final int HANDLE_UPDATE_EXISTING = 3;
    public static final int HANDLE_CREATED = 4;
    private static final String READ_ONLY_FLAG = "u=rw";
    private static final String EXECUTE_FLAG = "x";

    public UpdatedHandler(int handlerType) {
        this.handlerType = handlerType;
    }

    public String getResponseID() {
        switch (this.handlerType) {
            case 1: {
                return "Updated";
            }
            case 2: {
                return "Merged";
            }
            case 3: {
                return "Update-existing";
            }
            case 4: {
                return "Created";
            }
        }
        return null;
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        block5: {
            String repositoryFile = session.readLine();
            String entryLine = session.readLine();
            byte[] entryBytes = entryLine.getBytes();
            String permissionsLine = session.readLine();
            Date modTime = session.getModTime();
            session.setModTime(null);
            String fileName = repositoryFile.substring(repositoryFile.lastIndexOf("/") + 1);
            ICVSFolder mParent = this.getExistingFolder(session, localDir);
            ICVSFile mFile = this.getTargetFile(mParent, fileName, entryBytes);
            boolean binary = ResourceSyncInfo.isBinary(entryBytes);
            boolean readOnly = permissionsLine.indexOf(READ_ONLY_FLAG) == -1;
            boolean executable = permissionsLine.indexOf(EXECUTE_FLAG) != -1;
            try {
                if (mFile.isReadOnly()) {
                    mFile.setReadOnly(false);
                }
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
            try {
                this.receiveTargetFile(session, mFile, entryLine, modTime, binary, readOnly, executable, monitor);
            }
            catch (CVSException e) {
                if (this.handleInvalidResourceName(session, mFile, e)) break block5;
                throw e;
            }
        }
    }

    protected ICVSFile getTargetFile(ICVSFolder mParent, String fileName, byte[] entryBytes) throws CVSException {
        return mParent.getFile(fileName);
    }

    protected void receiveTargetFile(Session session, ICVSFile mFile, String entryLine, Date modTime, boolean binary, boolean readOnly, boolean executable, IProgressMonitor monitor) throws CVSException {
        session.receiveFile(mFile, binary, this.handlerType, monitor);
        mFile.setTimeStamp(modTime);
        modTime = mFile.getTimeStamp();
        ResourceSyncInfo info = new ResourceSyncInfo(entryLine, null);
        MutableResourceSyncInfo newInfoWithTimestamp = info.cloneMutable();
        newInfoWithTimestamp.setTimeStamp(modTime);
        int modificationState = 0;
        if (this.handlerType == 2) {
            newInfoWithTimestamp.setMerged();
        } else if (!(session.isIgnoringLocalChanges() || info.isAdded() || this.handlerType != 3 && this.handlerType != 4)) {
            modificationState = 1;
            CVSProviderPlugin.getPlugin().getFileModificationManager().updated(mFile);
        }
        mFile.setSyncInfo(newInfoWithTimestamp, modificationState);
        try {
            if (readOnly) {
                mFile.setReadOnly(true);
            }
            if (executable) {
                mFile.setExecutable(true);
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
    }

    public int getHandlerType() {
        return this.handlerType;
    }
}

