/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;

public class MultipleYesNoPrompter {
    private static final int ALWAYS_ASK = 0;
    private static final int YES_TO_ALL = 1;
    private static final int NO_TO_ALL = 2;
    private String[] buttons;
    private int confirmation = 0;
    private String title;
    private boolean hasMultiple;
    private boolean allOrNothing;
    private IShellProvider shellProvider;

    public MultipleYesNoPrompter(IShellProvider provider, String title, boolean hasMultiple, boolean allOrNothing) {
        this.title = title;
        this.shellProvider = provider;
        this.hasMultiple = hasMultiple;
        this.allOrNothing = allOrNothing;
        this.buttons = hasMultiple ? (allOrNothing ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}) : new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
    }

    public boolean shouldInclude(String message) throws InterruptedException {
        if (this.confirmation == 1) {
            return true;
        }
        switch (this.confirmation) {
            case 0: {
                if (!this.confirmOverwrite(message)) break;
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private boolean confirmOverwrite(String msg) throws InterruptedException {
        Shell shell = this.shellProvider.getShell();
        if (shell == null) {
            return false;
        }
        final MessageDialog dialog = new MessageDialog(shell, this.title, null, msg, 3, this.buttons, 0);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        if (this.hasMultiple) {
            switch (dialog.getReturnCode()) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.confirmation = 1;
                    return true;
                }
                case 2: {
                    if (this.allOrNothing) {
                        throw new InterruptedException();
                    }
                    return false;
                }
                case 3: {
                    this.confirmation = 2;
                    return false;
                }
            }
            throw new InterruptedException();
        }
        return dialog.getReturnCode() == 0;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

