/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.sig;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHParameters
extends AlgorithmParametersSpi {
    private BigInteger p;
    private BigInteger g;
    private BigInteger q;
    private int l;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Wrong AlgorithmParameterSpec type: " + algorithmParameterSpec.getClass().getName());
        }
        DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
        this.p = dHParameterSpec.getP();
        this.g = dHParameterSpec.getG();
        this.l = dHParameterSpec.getL();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        DerUtil.checkIsConstructed(dERValue, "Wrong DH Parameters field");
        DERValue dERValue2 = dERReader.read();
        DerUtil.checkIsBigInteger(dERValue2, "Wrong P field");
        this.p = (BigInteger)dERValue2.getValue();
        dERValue2 = dERReader.read();
        DerUtil.checkIsBigInteger(dERValue2, "Wrong G field");
        this.g = (BigInteger)dERValue2.getValue();
        dERValue2 = dERReader.read();
        DerUtil.checkIsBigInteger(dERValue2, "Wrong Q field");
        this.q = (BigInteger)dERValue2.getValue();
        this.l = this.q.bitLength();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                throw new IOException("Format MUST NOT be an empty string");
            }
            if (!string.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown or unsupported format: " + string);
            }
        }
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(DHParameters.class$("javax.crypto.spec.DHParameterSpec"))) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        if (clazz.isAssignableFrom(DHParameters.class$("javax.crypto.spec.DHGenParameterSpec"))) {
            return new DHGenParameterSpec(this.p.bitLength(), this.l);
        }
        throw new InvalidParameterSpecException("Wrong AlgorithmParameterSpec type: " + clazz.getName());
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        DERValue dERValue = new DERValue(2, this.p);
        DERValue dERValue2 = new DERValue(2, this.g);
        DERValue dERValue3 = new DERValue(2, this.q);
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(dERValue);
        arrayList.add(dERValue2);
        arrayList.add(dERValue3);
        DERValue dERValue4 = new DERValue(48, arrayList);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERWriter.write(byteArrayOutputStream, dERValue4);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                throw new IOException("Format MUST NOT be an empty string");
            }
            if (!string.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown or unsupported format: " + string);
            }
        }
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer("p=");
        if (this.p == null) {
            stringBuffer.append("???");
        } else {
            stringBuffer.append("0x").append(this.p.toString(16));
        }
        stringBuffer.append(", g=");
        if (this.g == null) {
            stringBuffer.append("???");
        } else {
            stringBuffer.append("0x").append(this.g.toString(16));
        }
        stringBuffer.append(", q=");
        if (this.q == null) {
            stringBuffer.append("???");
        } else {
            stringBuffer.append("0x").append(this.q.toString(16));
        }
        stringBuffer.append(", l=").append(this.l);
        return stringBuffer.toString();
    }
}

