/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.JPEGDecoder;
import gnu.javax.imageio.jpeg.JPEGException;
import gnu.javax.imageio.jpeg.JPEGImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class JPEGImageReaderSpi
extends ImageReaderSpi {
    static final String vendorName = "GNU";
    static final String version = "0.1";
    static final String readerClassName = "gnu.javax.imageio.jpeg.JPEGImageReader";
    static final String[] names;
    static final String[] suffixes;
    static final String[] MIMETypes;
    static final String[] writerSpiNames;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;
    private static JPEGImageReaderSpi readerSpi;

    public JPEGImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        System.out.println("JPEGImageReaderSPI!!!");
    }

    public String getDescription(Locale locale) {
        return "JPEG ISO 10918-1, JFIF V1.02";
    }

    public boolean canDecodeInput(Object object) throws IOException {
        boolean bl;
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            new JPEGDecoder(imageInputStream);
            bl = true;
        }
        catch (JPEGException jPEGException) {
            bl = false;
        }
        imageInputStream.reset();
        return bl;
    }

    public ImageReader createReaderInstance(Object object) {
        return new JPEGImageReader(this);
    }

    public static void registerSpis(IIORegistry iIORegistry) {
        iIORegistry.registerServiceProvider(JPEGImageReaderSpi.getReaderSpi(), JPEGImageReaderSpi.class$("javax.imageio.spi.ImageReaderSpi"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static synchronized JPEGImageReaderSpi getReaderSpi() {
        if (readerSpi == null) {
            readerSpi = new JPEGImageReaderSpi();
        }
        return readerSpi;
    }

    static {
        vendorName = vendorName;
        version = version;
        readerClassName = readerClassName;
        names = new String[]{"JPEG"};
        suffixes = new String[]{".jpeg", ".jpg", ".jpe"};
        MIMETypes = new String[]{"image/jpeg"};
        writerSpiNames = new String[]{"gnu.javax.imageio.jpeg.JPEGImageWriterSpi"};
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = null;
        extraStreamMetadataFormatClassNames = null;
        nativeImageMetadataFormatName = null;
        nativeImageMetadataFormatClassName = null;
        extraImageMetadataFormatNames = null;
        extraImageMetadataFormatClassNames = null;
    }
}

