/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA;

import gnu.CORBA.typecodes.ArrayTypeCode;
import gnu.CORBA.typecodes.FixedTypeCode;
import gnu.CORBA.typecodes.GeneralTypeCode;
import gnu.CORBA.typecodes.PrimitiveTypeCode;
import gnu.CORBA.typecodes.RecordTypeCode;
import gnu.CORBA.typecodes.StringTypeCode;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class TypeCodeHelper {
    public static TypeCode read(InputStream inputStream) throws BadKind, Bounds {
        PrimitiveTypeCode primitiveTypeCode;
        TCKind tCKind = TCKind.from_int(inputStream.read_long());
        switch (tCKind.value()) {
            case 19: 
            case 20: {
                ArrayTypeCode arrayTypeCode = new ArrayTypeCode(tCKind);
                arrayTypeCode.setLength(inputStream.read_long());
                primitiveTypeCode = arrayTypeCode;
                break;
            }
            case 18: 
            case 27: {
                StringTypeCode stringTypeCode = new StringTypeCode(tCKind);
                stringTypeCode.setLength(inputStream.read_long());
                primitiveTypeCode = stringTypeCode;
                break;
            }
            case 28: {
                FixedTypeCode fixedTypeCode = new FixedTypeCode();
                fixedTypeCode.setDigits(inputStream.read_short());
                fixedTypeCode.setScale(inputStream.read_short());
                primitiveTypeCode = fixedTypeCode;
                break;
            }
            case 14: 
            case 31: 
            case 32: {
                GeneralTypeCode generalTypeCode = new GeneralTypeCode(tCKind);
                generalTypeCode.setId(inputStream.read_string());
                generalTypeCode.setName(inputStream.read_string());
                primitiveTypeCode = generalTypeCode;
                break;
            }
            case 21: 
            case 30: {
                GeneralTypeCode generalTypeCode = new GeneralTypeCode(tCKind);
                generalTypeCode.setId(inputStream.read_string());
                generalTypeCode.setName(inputStream.read_string());
                generalTypeCode.setContentType(inputStream.read_TypeCode());
                primitiveTypeCode = generalTypeCode;
                break;
            }
            case 15: 
            case 22: {
                RecordTypeCode recordTypeCode = new RecordTypeCode(tCKind);
                recordTypeCode.setId(inputStream.read_string());
                recordTypeCode.setName(inputStream.read_string());
                int n = inputStream.read_long();
                for (int i = 0; i < n; ++i) {
                    RecordTypeCode.Field field = recordTypeCode.field();
                    field.name = inputStream.read_string();
                    field.type = inputStream.read_TypeCode();
                }
                primitiveTypeCode = recordTypeCode;
                break;
            }
            case 17: {
                RecordTypeCode recordTypeCode = new RecordTypeCode(tCKind);
                recordTypeCode.setId(inputStream.read_string());
                recordTypeCode.setName(inputStream.read_string());
                int n = inputStream.read_long();
                for (int i = 0; i < n; ++i) {
                    RecordTypeCode.Field field = recordTypeCode.field();
                    field.name = inputStream.read_string();
                }
                primitiveTypeCode = recordTypeCode;
                break;
            }
            case 16: {
                RecordTypeCode recordTypeCode = new RecordTypeCode(tCKind);
                recordTypeCode.setId(inputStream.read_string());
                recordTypeCode.setName(inputStream.read_string());
                recordTypeCode.setDiscriminator_type(inputStream.read_TypeCode());
                recordTypeCode.setDefaultIndex(inputStream.read_long());
                int n = inputStream.read_long();
                for (int i = 0; i < n; ++i) {
                    RecordTypeCode.Field field = recordTypeCode.field();
                    field.label = inputStream.read_any();
                    field.name = inputStream.read_string();
                    field.type = inputStream.read_TypeCode();
                }
                primitiveTypeCode = recordTypeCode;
                break;
            }
            case 29: {
                RecordTypeCode recordTypeCode = new RecordTypeCode(tCKind);
                recordTypeCode.setId(inputStream.read_string());
                recordTypeCode.setName(inputStream.read_string());
                recordTypeCode.setTypeModifier(inputStream.read_short());
                recordTypeCode.setConcreteBase_type(inputStream.read_TypeCode());
                int n = inputStream.read_long();
                for (int i = 0; i < n; ++i) {
                    RecordTypeCode.Field field = recordTypeCode.field();
                    field.name = inputStream.read_string();
                    field.type = inputStream.read_TypeCode();
                    field.visibility = inputStream.read_short();
                }
                primitiveTypeCode = recordTypeCode;
                break;
            }
            default: {
                primitiveTypeCode = new PrimitiveTypeCode(tCKind);
            }
        }
        return primitiveTypeCode;
    }

    public static void write(OutputStream outputStream, TypeCode typeCode) throws BadKind, Bounds {
        outputStream.write_long(typeCode.kind().value());
        switch (typeCode.kind().value()) {
            case 18: 
            case 27: {
                outputStream.write_long(typeCode.length());
                break;
            }
            case 19: 
            case 20: {
                TypeCodeHelper.write(outputStream, typeCode.content_type());
                outputStream.write_long(typeCode.length());
                break;
            }
            case 28: {
                outputStream.write_short(typeCode.fixed_digits());
                outputStream.write_short(typeCode.fixed_scale());
                break;
            }
            case 14: 
            case 31: 
            case 32: {
                outputStream.write_string(typeCode.id());
                outputStream.write_string(typeCode.name());
                break;
            }
            case 21: 
            case 30: {
                outputStream.write_string(typeCode.id());
                outputStream.write_string(typeCode.name());
                TypeCodeHelper.write(outputStream, typeCode.content_type());
                break;
            }
            case 15: 
            case 22: {
                outputStream.write_string(typeCode.id());
                outputStream.write_string(typeCode.name());
                outputStream.write_long(typeCode.member_count());
                for (int i = 0; i < typeCode.member_count(); ++i) {
                    outputStream.write_string(typeCode.member_name(i));
                    TypeCodeHelper.write(outputStream, typeCode.member_type(i));
                }
                break;
            }
            case 17: {
                outputStream.write_string(typeCode.id());
                outputStream.write_string(typeCode.name());
                outputStream.write_long(typeCode.member_count());
                for (int i = 0; i < typeCode.member_count(); ++i) {
                    outputStream.write_string(typeCode.member_name(i));
                }
                break;
            }
            case 16: {
                outputStream.write_string(typeCode.id());
                outputStream.write_string(typeCode.name());
                TypeCodeHelper.write(outputStream, typeCode.discriminator_type());
                outputStream.write_long(typeCode.default_index());
                outputStream.write_long(typeCode.member_count());
                for (int i = 0; i < typeCode.member_count(); ++i) {
                    outputStream.write_any(typeCode.member_label(i));
                    outputStream.write_string(typeCode.member_name(i));
                    TypeCodeHelper.write(outputStream, typeCode.member_type(i));
                }
                break;
            }
            case 29: {
                outputStream.write_string(typeCode.id());
                outputStream.write_string(typeCode.name());
                outputStream.write_short(typeCode.type_modifier());
                TypeCodeHelper.write(outputStream, typeCode.concrete_base_type());
                outputStream.write_long(typeCode.member_count());
                for (int i = 0; i < typeCode.member_count(); ++i) {
                    outputStream.write_string(typeCode.member_name(i));
                    TypeCodeHelper.write(outputStream, typeCode.member_type(i));
                    outputStream.write_short(typeCode.member_visibility(i));
                }
                break;
            }
        }
    }
}

