/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.SSLSocket;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLException;

class SSLSocketOutputStream
extends FilterOutputStream {
    private final SSLSocket socket;
    private final boolean checkHandshake;

    SSLSocketOutputStream(OutputStream outputStream, SSLSocket sSLSocket) {
        this(outputStream, sSLSocket, true);
    }

    SSLSocketOutputStream(OutputStream outputStream, SSLSocket sSLSocket, boolean bl) {
        super(outputStream);
        this.socket = sSLSocket;
        this.checkHandshake = bl;
    }

    public void write(int n) throws IOException {
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        this.checkAlert();
        this.out.write(n);
        this.checkAlert();
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.checkAlert();
        this.out.write(byArray, n, n2);
        this.checkAlert();
    }

    private synchronized void checkAlert() throws SSLException {
        Alert alert = this.socket.checkAlert();
        if (alert == null) {
            return;
        }
        if (alert.getLevel().equals(Alert.Level.FATAL)) {
            throw new AlertException(alert, false);
        }
    }
}

