/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.sax;

import gnu.xml.libxmlj.sax.GnomeLocator;
import gnu.xml.libxmlj.sax.Namespaces;
import gnu.xml.libxmlj.sax.StringArrayAttributes;
import gnu.xml.libxmlj.sax.XMLName;
import gnu.xml.libxmlj.util.NamedInputStream;
import gnu.xml.libxmlj.util.StandaloneLocator;
import gnu.xml.libxmlj.util.XMLJ;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class GnomeXMLReader
implements XMLReader {
    private static final String FEATURES_PREFIX = "http://xml.org/sax/features/";
    private static final List RECOGNIZED_FEATURES;
    private static final String PROPERTIES_PREFIX = "http://xml.org/sax/properties/";
    private static final List RECOGNIZED_PROPERTIES;
    private transient boolean standalone;
    private boolean namespaces;
    private boolean namespacePrefixes;
    private boolean validation;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private DeclHandler declarationHandler;
    private LexicalHandler lexicalHandler;
    private GnomeLocator locator;
    private transient Namespaces ns;
    private transient boolean seenFatalError;
    private transient boolean seenStartDocument;
    private transient String base;

    public GnomeXMLReader() {
        this(true, true);
    }

    public GnomeXMLReader(boolean bl, boolean bl2) {
        this.namespaces = bl;
        this.validation = bl2;
        this.ns = new Namespaces();
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        GnomeXMLReader.checkFeatureName(string);
        String string2 = string.substring(FEATURES_PREFIX.length());
        if ("external-general-entities".equals(string2)) {
            return this.validation;
        }
        if ("external-parameter-entities".equals(string2)) {
            return this.validation;
        }
        if ("is-standalone".equals(string2)) {
            return this.standalone;
        }
        if ("namespaces".equals(string2)) {
            return this.namespaces;
        }
        if ("namespace-prefixes".equals(string2)) {
            return this.namespacePrefixes;
        }
        if ("resolve-dtd-uris".equals(string2)) {
            return true;
        }
        if ("validation".equals(string2)) {
            return this.validation;
        }
        return false;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        GnomeXMLReader.checkFeatureName(string);
        String string2 = string.substring(FEATURES_PREFIX.length());
        if ("namespaces".equals(string2)) {
            this.namespaces = bl;
        } else if ("namespace-prefixes".equals(string2)) {
            this.namespacePrefixes = bl;
        } else if ("validation".equals(string2)) {
            this.validation = bl;
        }
    }

    static void checkFeatureName(String string) throws SAXNotRecognizedException {
        if (string == null || !string.startsWith(FEATURES_PREFIX)) {
            throw new SAXNotRecognizedException(string);
        }
        String string2 = string.substring(FEATURES_PREFIX.length());
        if (!RECOGNIZED_FEATURES.contains(string2)) {
            throw new SAXNotRecognizedException(string);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        GnomeXMLReader.checkPropertyName(string);
        String string2 = string.substring(PROPERTIES_PREFIX.length());
        if ("declaration-handler".equals(string2)) {
            return this.getDeclarationHandler();
        }
        if ("lexical-handler".equals(string2)) {
            return this.getLexicalHandler();
        }
        throw new SAXNotSupportedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        GnomeXMLReader.checkPropertyName(string);
        String string2 = string.substring(PROPERTIES_PREFIX.length());
        if ("declaration-handler".equals(string2)) {
            this.setDeclarationHandler((DeclHandler)object);
        } else if ("lexical-handler".equals(string2)) {
            this.setLexicalHandler((LexicalHandler)object);
        }
    }

    public DeclHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    public void setDeclarationHandler(DeclHandler declHandler) {
        this.declarationHandler = declHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    static void checkPropertyName(String string) throws SAXNotRecognizedException {
        if (!string.startsWith(PROPERTIES_PREFIX)) {
            throw new SAXNotRecognizedException(string);
        }
        String string2 = string.substring(PROPERTIES_PREFIX.length());
        if (!RECOGNIZED_PROPERTIES.contains(string2)) {
            throw new SAXNotRecognizedException(string);
        }
    }

    public void parse(String string) throws IOException, SAXException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (!file.exists()) {
                throw new FileNotFoundException(string);
            }
            String string2 = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                string2 = string2.replace(File.separatorChar, '/');
            }
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            if (!string2.endsWith("/") && file.isDirectory()) {
                string2 = string2 + "/";
            }
            uRL = new URL("file:" + string2);
        }
        InputSource inputSource = new InputSource(uRL.toString());
        inputSource.setByteStream(uRL.openStream());
        this.parse(inputSource);
    }

    public synchronized void parse(InputSource inputSource) throws IOException, SAXException {
        int n;
        NamedInputStream namedInputStream = XMLJ.getInputStream(inputSource);
        byte[] byArray = namedInputStream.getDetectBuffer();
        String string = inputSource.getPublicId();
        String string2 = inputSource.getSystemId();
        this.base = XMLJ.getBaseURI(string2);
        this.standalone = false;
        this.seenFatalError = false;
        this.seenStartDocument = false;
        if (string2 != null && (n = string2.lastIndexOf(47)) != -1) {
            this.base = string2.substring(0, n + 1);
        }
        if (byArray == null) {
            this.startDocument(true);
            this.fatalError("No document element", 0, 0, string, string2);
            this.endDocument();
            return;
        }
        this.parseStream(namedInputStream, byArray, string, string2, this.base, this.validation, this.contentHandler != null, this.dtdHandler != null, this.entityResolver != null, this.errorHandler != null, this.declarationHandler != null, this.lexicalHandler != null);
        namedInputStream.close();
    }

    native void parseStream(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, boolean var12) throws IOException, SAXException;

    String getURI(String string) {
        if (!this.namespaces) {
            return null;
        }
        return this.ns.getURI(string);
    }

    private void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.seenFatalError || this.lexicalHandler == null) {
            return;
        }
        try {
            string3 = XMLJ.getAbsoluteURI(this.base, string3);
            this.lexicalHandler.startDTD(string, string2, string3);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this.seenFatalError || this.declarationHandler == null) {
            return;
        }
        try {
            string3 = XMLJ.getAbsoluteURI(this.base, string3);
            this.declarationHandler.externalEntityDecl(string, string2, string3);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.seenFatalError || this.declarationHandler == null) {
            return;
        }
        try {
            this.declarationHandler.internalEntityDecl(string, string2);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private InputStream resolveEntity(String string, String string2) throws SAXException, IOException {
        if (this.entityResolver == null) {
            return null;
        }
        try {
            string2 = XMLJ.getAbsoluteURI(this.base, string2);
            InputSource inputSource = this.entityResolver.resolveEntity(string, string2);
            if (inputSource != null) {
                return XMLJ.getInputStream(inputSource);
            }
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this.seenFatalError || this.dtdHandler == null) {
            return;
        }
        try {
            string3 = XMLJ.getAbsoluteURI(this.base, string3);
            this.dtdHandler.notationDecl(string, string2, string3);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.seenFatalError || this.declarationHandler == null) {
            return;
        }
        try {
            this.declarationHandler.attributeDecl(string, string2, string3, string4, string5);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void elementDecl(String string, String string2) throws SAXException {
        if (this.seenFatalError || this.declarationHandler == null) {
            return;
        }
        try {
            this.declarationHandler.elementDecl(string, string2);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this.seenFatalError || this.dtdHandler == null) {
            return;
        }
        try {
            string3 = XMLJ.getAbsoluteURI(this.base, string3);
            this.dtdHandler.unparsedEntityDecl(string, string2, string3, string4);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void setDocumentLocator(Object object, Object object2) {
        this.locator = new GnomeLocator(object, object2);
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        try {
            this.contentHandler.setDocumentLocator(this.locator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startDocument(boolean bl) throws SAXException {
        this.standalone = bl;
        this.seenStartDocument = true;
        if (this.contentHandler == null) {
            return;
        }
        try {
            this.contentHandler.startDocument();
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void endDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        try {
            this.contentHandler.endDocument();
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void startElement(String string, String[] stringArray) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        try {
            XMLName xMLName = new XMLName(this, string);
            if (this.namespaces) {
                int n;
                this.ns.push();
                int n2 = n = stringArray == null ? 0 : stringArray.length;
                if (n > 0) {
                    ArrayList arrayList = new ArrayList(n);
                    for (int i = 0; i < n; i += 2) {
                        String string2 = stringArray[i];
                        String string3 = stringArray[i + 1];
                        if (string2.equals("xmlns")) {
                            this.startPrefixMapping("", string3);
                            continue;
                        }
                        if (string2.startsWith("xmlns:")) {
                            this.startPrefixMapping(string2.substring(6), string3);
                            continue;
                        }
                        arrayList.add(string2);
                        arrayList.add(string3);
                    }
                    stringArray = new String[arrayList.size()];
                    arrayList.toArray(stringArray);
                }
            }
            StringArrayAttributes stringArrayAttributes = new StringArrayAttributes(this, stringArray);
            this.contentHandler.startElement(xMLName.uri, xMLName.localName, xMLName.qName, stringArrayAttributes);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void endElement(String string) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        try {
            XMLName xMLName = new XMLName(this, string);
            String string2 = xMLName.uri == null ? "" : xMLName.uri;
            this.contentHandler.endElement(string2, xMLName.localName, xMLName.qName);
            if (this.namespaces) {
                Iterator iterator = this.ns.currentPrefixes();
                while (iterator.hasNext()) {
                    this.endPrefixMapping((String)iterator.next());
                }
                this.ns.pop();
            }
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        this.ns.define(string, string2);
        this.contentHandler.startPrefixMapping(string, string2);
    }

    private void endPrefixMapping(String string) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        this.contentHandler.endPrefixMapping(string);
    }

    private void characters(String string) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null || string == null) {
            return;
        }
        try {
            char[] cArray = string.toCharArray();
            this.contentHandler.characters(cArray, 0, cArray.length);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void ignorableWhitespace(String string) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null || string == null) {
            return;
        }
        try {
            char[] cArray = string.toCharArray();
            this.contentHandler.ignorableWhitespace(cArray, 0, cArray.length);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void processingInstruction(String string, String string2) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        try {
            if (string2 == null) {
                string2 = "";
            }
            this.contentHandler.processingInstruction(string, string2);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void comment(String string) throws SAXException {
        if (this.seenFatalError || this.lexicalHandler == null || string == null) {
            return;
        }
        try {
            char[] cArray = string.toCharArray();
            this.lexicalHandler.comment(cArray, 0, cArray.length);
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void cdataBlock(String string) throws SAXException {
        if (this.seenFatalError || string == null) {
            return;
        }
        try {
            if (this.lexicalHandler == null) {
                this.characters(string);
            } else {
                this.lexicalHandler.startCDATA();
                this.characters(string);
                this.lexicalHandler.endCDATA();
            }
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void warning(String string, int n, int n2, String string2, String string3) throws SAXException {
        if (this.seenFatalError || this.errorHandler == null) {
            return;
        }
        try {
            StandaloneLocator standaloneLocator = new StandaloneLocator(n, n2, string2, string3);
            this.errorHandler.warning(new SAXParseException(string, standaloneLocator));
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void error(String string, int n, int n2, String string2, String string3) throws SAXException {
        if (this.seenFatalError || this.errorHandler == null) {
            return;
        }
        try {
            StandaloneLocator standaloneLocator = new StandaloneLocator(n, n2, string2, string3);
            this.errorHandler.error(new SAXParseException(string, standaloneLocator));
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void fatalError(String string, int n, int n2, String string2, String string3) throws SAXException {
        if (this.seenFatalError || this.errorHandler == null) {
            return;
        }
        try {
            if (!this.seenStartDocument) {
                this.startDocument(false);
            }
            this.seenFatalError = true;
            StandaloneLocator standaloneLocator = new StandaloneLocator(n, n2, string2, string3);
            this.errorHandler.fatalError(new SAXParseException(string, standaloneLocator));
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    static {
        XMLJ.init();
        FEATURES_PREFIX = FEATURES_PREFIX;
        RECOGNIZED_FEATURES = Arrays.asList(new String[]{"external-general-entities", "external-parameter-entities", "is-standalone", "lexical-handler/parameter-entities", "namespaces", "namespace-prefixes", "resolve-dtd-uris", "string-interning", "use-attributes2", "use-locator2", "use-entity-resolver2", "validation"});
        PROPERTIES_PREFIX = PROPERTIES_PREFIX;
        RECOGNIZED_PROPERTIES = Arrays.asList(new String[]{"declaration-handler", "dom-node", "lexical-handler", "xml-string"});
    }
}

