/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    static final int DEFAULT_CAPACITY = 11;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 362498820763181265L;
    private int threshold;
    final float loadFactor;
    transient HashEntry[] buckets;
    transient int modCount;
    transient int size;
    private transient Set entries;

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(Map map) {
        this(Math.max(map.size() * 2, 11), 0.75f);
        this.putAll(map);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.buckets = new HashEntry[n];
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (AbstractMap.equals(object, hashEntry.key)) {
                return hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public boolean containsKey(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (AbstractMap.equals(object, hashEntry.key)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object object, Object object2) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (AbstractMap.equals(object, hashEntry.key)) {
                hashEntry.access();
                Object object3 = hashEntry.value;
                hashEntry.value = object2;
                return object3;
            }
            hashEntry = hashEntry.next;
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            n = this.hash(object);
        }
        this.addEntry(object, object2, n, true);
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (entry instanceof AbstractMap.BasicMapEntry) {
                AbstractMap.BasicMapEntry basicMapEntry = (AbstractMap.BasicMapEntry)entry;
                this.put(basicMapEntry.key, basicMapEntry.value);
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (AbstractMap.equals(object, hashEntry.key)) {
                ++this.modCount;
                if (hashEntry2 == null) {
                    this.buckets[n] = hashEntry.next;
                } else {
                    hashEntry2.next = hashEntry.next;
                }
                --this.size;
                return hashEntry.cleanup();
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    public boolean containsValue(Object object) {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            HashEntry hashEntry = this.buckets[i];
            while (hashEntry != null) {
                if (AbstractMap.equals(object, hashEntry.value)) {
                    return true;
                }
                hashEntry = hashEntry.next;
            }
        }
        return false;
    }

    public Object clone() {
        HashMap hashMap = null;
        try {
            hashMap = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashMap.buckets = new HashEntry[this.buckets.length];
        hashMap.putAllInternal(this);
        hashMap.entries = null;
        return hashMap;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(this){
                private /* synthetic */ HashMap this$0;
                {
                    this.this$0 = hashMap;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return this.this$0.iterator(0);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = this.this$0.size;
                    this.this$0.remove(object);
                    return this.this$0.size != n;
                }
            };
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(this){
                private /* synthetic */ HashMap this$0;
                {
                    this.this$0 = hashMap;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return this.this$0.iterator(1);
                }

                public void clear() {
                    this.this$0.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(this){
                private /* synthetic */ HashMap this$0;
                {
                    this.this$0 = hashMap;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return this.this$0.iterator(2);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.getEntry(object) != null;
                }

                public boolean remove(Object object) {
                    HashEntry hashEntry = this.this$0.getEntry(object);
                    if (hashEntry != null) {
                        this.this$0.remove(hashEntry.key);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    void addEntry(Object object, Object object2, int n, boolean bl) {
        HashEntry hashEntry = new HashEntry(object, object2);
        hashEntry.next = this.buckets[n];
        this.buckets[n] = hashEntry;
    }

    final HashEntry getEntry(Object object) {
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)object;
        Object object2 = entry.getKey();
        int n = this.hash(object2);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (AbstractMap.equals(hashEntry.key, object2)) {
                if (AbstractMap.equals(hashEntry.value, entry.getValue())) {
                    return hashEntry;
                }
                return null;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    final int hash(Object object) {
        if (object == null) {
            return 0;
        }
        return Math.abs(object.hashCode() % this.buckets.length);
    }

    Iterator iterator(int n) {
        return new HashIterator(this, n);
    }

    void putAllInternal(Map map) {
        Iterator iterator = map.entrySet().iterator();
        this.size = 0;
        while (iterator.hasNext()) {
            ++this.size;
            Map.Entry entry = (Map.Entry)iterator.next();
            Object object = entry.getKey();
            int n = this.hash(object);
            this.addEntry(object, entry.getValue(), n, false);
        }
    }

    private void rehash() {
        HashEntry[] hashEntryArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new HashEntry[n];
        for (int i = hashEntryArray.length - 1; i >= 0; --i) {
            HashEntry hashEntry = hashEntryArray[i];
            while (hashEntry != null) {
                int n2 = this.hash(hashEntry.key);
                HashEntry hashEntry2 = this.buckets[n2];
                HashEntry hashEntry3 = hashEntry.next;
                hashEntry.next = this.buckets[n2];
                this.buckets[n2] = hashEntry;
                hashEntry = hashEntry3;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.buckets.length);
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.iterator(2);
        while (iterator.hasNext()) {
            HashEntry hashEntry = (HashEntry)iterator.next();
            objectOutputStream.writeObject(hashEntry.key);
            objectOutputStream.writeObject(hashEntry.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        this.buckets = new HashEntry[objectInputStream.readInt()];
        this.size = n = objectInputStream.readInt();
        while (n-- > 0) {
            Object object = objectInputStream.readObject();
            this.addEntry(object, objectInputStream.readObject(), this.hash(object), false);
        }
    }

    private final class HashIterator
    implements Iterator {
        private /* synthetic */ HashMap this$0;
        private final int type;
        private int knownMod;
        private int count;
        private int idx;
        private HashEntry last;
        private HashEntry next;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
            this.count = this.this$0.size;
            this.idx = this.this$0.buckets.length;
        }

        HashIterator(HashMap hashMap, int n) {
            this.this$0 = hashMap;
            this.finit$();
            this.type = n;
        }

        public boolean hasNext() {
            return this.count > 0;
        }

        public Object next() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                hashEntry = this.this$0.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            this.last = hashEntry;
            if (this.type == 1) {
                return hashEntry.value;
            }
            if (this.type == 0) {
                return hashEntry.key;
            }
            return hashEntry;
        }

        public void remove() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    static class HashEntry
    extends AbstractMap.BasicMapEntry {
        HashEntry next;

        HashEntry(Object object, Object object2) {
            super(object, object2);
        }

        void access() {
        }

        Object cleanup() {
            return this.value;
        }
    }
}

