/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.InternalFrameUI;

public class JInternalFrame
extends JComponent
implements Accessible,
WindowConstants,
RootPaneContainer {
    private static final long serialVersionUID = -5425177187760785402L;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String FRAME_ICON_PROPERTY = "frameIcon";
    public static final String GLASS_PANE_PROPERTY = "glassPane";
    public static final String IS_CLOSED_PROPERTY = "closed";
    public static final String IS_ICON_PROPERTY = "icon";
    public static final String IS_MAXIMUM_PROPERTY = "maximum";
    public static final String IS_SELECTED_PROPERTY = "selected";
    public static final String LAYERED_PANE_PROPERTY = "layeredPane";
    public static final String MENU_BAR_PROPERTY = "JMenuBar";
    public static final String ROOT_PANE_PROPERTY = "rootPane";
    public static final String TITLE_PROPERTY = "title";
    protected boolean closable;
    protected boolean iconable;
    protected boolean isClosed;
    protected boolean isIcon;
    protected boolean isMaximum;
    protected boolean isSelected;
    protected boolean maximizable;
    protected boolean rootPaneCheckingEnabled;
    protected boolean resizable;
    protected JDesktopIcon desktopIcon;
    protected Icon frameIcon;
    protected JRootPane rootPane;
    protected String title;
    private transient Rectangle storedBounds;
    private transient Component defaultFocus;
    private transient int defaultCloseOperation;
    private transient boolean isFirstTimeVisible;
    private transient boolean wasIcon;

    private /* synthetic */ void finit$() {
        this.rootPaneCheckingEnabled = false;
        this.defaultCloseOperation = 2;
        this.isFirstTimeVisible = true;
        this.wasIcon = false;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JInternalFrame() {
        this("", false, false, false, false);
    }

    public JInternalFrame(String string) {
        this(string, false, false, false, false);
    }

    public JInternalFrame(String string, boolean bl) {
        this(string, bl, false, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3) {
        this(string, bl, bl2, bl3, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.finit$();
        this.title = string;
        this.resizable = bl;
        this.closable = bl2;
        this.maximizable = bl3;
        this.iconable = bl4;
        this.isMaximum = false;
        this.setRootPane(this.createRootPane());
        this.setVisible(false);
        this.setOpaque(true);
        this.desktopIcon = new JDesktopIcon(this);
        this.updateUI();
        this.setRootPaneCheckingEnabled(true);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void addInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.add(JInternalFrame.class$("javax.swing.event.InternalFrameListener"), internalFrameListener);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        if (this.isSelected()) {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!this.isClosed) {
            this.firePropertyChange(IS_CLOSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            this.isClosed = true;
        }
        this.fireInternalFrameEvent(25551);
    }

    public void doDefaultCloseAction() {
        this.fireInternalFrameEvent(25550);
        switch (this.getDefaultCloseOperation()) {
            case 1: {
                this.setVisible(false);
                break;
            }
            case 2: {
                this.dispose();
            }
        }
    }

    protected void fireInternalFrameEvent(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(this, n);
        switch (n) {
            case 25550: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameClosing(internalFrameEvent);
                }
                break;
            }
            case 25554: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameActivated(internalFrameEvent);
                }
                break;
            }
            case 25551: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameClosed(internalFrameEvent);
                }
                break;
            }
            case 25555: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameDeactivated(internalFrameEvent);
                }
                break;
            }
            case 25553: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameDeiconified(internalFrameEvent);
                }
                break;
            }
            case 25552: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameIconified(internalFrameEvent);
                }
                break;
            }
            case 25549: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameOpened(internalFrameEvent);
                }
                break;
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJInternalFrame(this);
        }
        return this.accessibleContext;
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public JDesktopIcon getDesktopIcon() {
        return this.desktopIcon;
    }

    public JDesktopPane getDesktopPane() {
        JDesktopPane jDesktopPane = (JDesktopPane)SwingUtilities.getAncestorOfClass(JInternalFrame.class$("javax.swing.JDesktopPane"), this);
        if (jDesktopPane == null && this.desktopIcon != null) {
            jDesktopPane = this.desktopIcon.getDesktopPane();
        }
        return jDesktopPane;
    }

    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public Component getFocusOwner() {
        Component component;
        if (this.isSelected() && SwingUtilities.isDescendingFrom(component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this)) {
            this.defaultFocus = component;
            return component;
        }
        return null;
    }

    public Icon getFrameIcon() {
        return this.frameIcon;
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public InternalFrameListener[] getInternalFrameListeners() {
        return (InternalFrameListener[])this.listenerList.getListeners(JInternalFrame.class$("javax.swing.event.InternalFrameListener"));
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public int getLayer() {
        return JLayeredPane.getLayer(this);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JMenuBar getMenuBar() {
        return this.getJMenuBar();
    }

    public Component getMostRecentFocusOwner() {
        if (this.isSelected()) {
            return this.getFocusOwner();
        }
        return this.defaultFocus;
    }

    public Rectangle getNormalBounds() {
        if (this.storedBounds == null) {
            return this.getBounds();
        }
        return this.storedBounds;
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public String getTitle() {
        return this.title;
    }

    public InternalFrameUI getUI() {
        return (InternalFrameUI)this.ui;
    }

    public String getUIClassID() {
        return "InternalFrameUI";
    }

    public final String getWarningString() {
        return null;
    }

    public void hide() {
        if (this.isIcon()) {
            this.getDesktopIcon().hide();
        }
        super.hide();
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public final boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    public boolean isIconifiable() {
        return this.iconable;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void moveToBack() {
        Container container = this.getParent();
        if (container instanceof JLayeredPane) {
            ((JLayeredPane)container).moveToBack(this);
        }
    }

    public void moveToFront() {
        Container container = this.getParent();
        if (container != null && container instanceof JLayeredPane) {
            ((JLayeredPane)container).moveToFront(this);
        }
    }

    public void pack() {
        try {
            if (this.isIcon()) {
                this.setIcon(false);
            } else if (this.isMaximum()) {
                this.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    protected String paramString() {
        return super.paramString() + ",title=" + this.getTitle();
    }

    public void remove(Component component) {
        if (component == this.rootPane || !this.isRootPaneCheckingEnabled()) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void removeInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.remove(JInternalFrame.class$("javax.swing.event.InternalFrameListener"), internalFrameListener);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.revalidate();
    }

    public void restoreSubcomponentFocus() {
        Component component = this.getMostRecentFocusOwner();
        if (component != null) {
            component.requestFocus();
        }
    }

    public void setClosable(boolean bl) {
        if (this.closable != bl) {
            this.closable = bl;
            this.firePropertyChange("closable", this.closable ^ true, this.closable);
        }
    }

    public void setClosed(boolean bl) throws PropertyVetoException {
        if (bl && !this.isClosed()) {
            this.fireInternalFrameEvent(25550);
            this.fireVetoableChange(IS_CLOSED_PROPERTY, false, true);
            this.isClosed = bl;
            this.dispose();
            this.firePropertyChange(IS_CLOSED_PROPERTY, false, true);
        }
    }

    public void setContentPane(Container container) {
        if (container != this.getContentPane()) {
            Container container2 = this.getContentPane();
            this.getRootPane().setContentPane(container);
            this.firePropertyChange(CONTENT_PANE_PROPERTY, container2, container);
        }
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public void setDesktopIcon(JDesktopIcon jDesktopIcon) {
        if (this.desktopIcon != jDesktopIcon) {
            JDesktopIcon jDesktopIcon2 = this.desktopIcon;
            this.desktopIcon = jDesktopIcon;
            this.firePropertyChange("desktopIcon", jDesktopIcon2, jDesktopIcon);
        }
    }

    public final void setFocusCycleRoot(boolean bl) {
    }

    public void setFrameIcon(Icon icon) {
        if (icon != this.frameIcon) {
            Icon icon2 = this.frameIcon;
            this.frameIcon = icon;
            this.firePropertyChange(FRAME_ICON_PROPERTY, icon2, this.frameIcon);
        }
    }

    public void setGlassPane(Component component) {
        if (component != this.getGlassPane()) {
            Component component2 = this.getGlassPane();
            this.getRootPane().setGlassPane(component);
            this.firePropertyChange(GLASS_PANE_PROPERTY, component2, component);
        }
    }

    public void setIcon(boolean bl) throws PropertyVetoException {
        if (bl != this.isIcon()) {
            this.fireVetoableChange(IS_ICON_PROPERTY, bl, this.isIcon);
            this.isIcon = bl;
            this.firePropertyChange(IS_ICON_PROPERTY, this.isIcon ^ true, this.isIcon);
            if (bl) {
                this.fireInternalFrameEvent(25552);
            } else {
                this.fireInternalFrameEvent(25553);
            }
        }
    }

    public void setIconifiable(boolean bl) {
        if (this.iconable != bl) {
            this.iconable = bl;
            this.firePropertyChange("iconable", this.iconable ^ true, this.iconable);
        }
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getJMenuBar();
        this.getRootPane().setJMenuBar(jMenuBar);
        this.firePropertyChange(MENU_BAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    public void setLayer(int n) {
        this.setLayer(new Integer(n));
    }

    public void setLayer(Integer n) {
        Container container = this.getParent();
        if (container instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)container;
            jLayeredPane.setLayer(this, n, jLayeredPane.getPosition(this));
        } else {
            JLayeredPane.putLayer(this, n);
            if (container != null) {
                container.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        }
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        if (jLayeredPane == null) {
            throw new IllegalComponentStateException("LayeredPane must not be null");
        }
        if (jLayeredPane != this.getLayeredPane()) {
            JLayeredPane jLayeredPane2 = this.getLayeredPane();
            this.getRootPane().setLayeredPane(jLayeredPane);
            this.firePropertyChange(LAYERED_PANE_PROPERTY, jLayeredPane2, jLayeredPane);
        }
    }

    public void setMaximizable(boolean bl) {
        if (this.maximizable != bl) {
            this.maximizable = bl;
            this.firePropertyChange("maximizable", this.maximizable ^ true, this.maximizable);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public void setMaximum(boolean bl) throws PropertyVetoException {
        if (bl != this.isMaximum) {
            this.fireVetoableChange(IS_MAXIMUM_PROPERTY, this.isMaximum, bl);
            this.isMaximum = bl;
            this.firePropertyChange(IS_MAXIMUM_PROPERTY, this.isMaximum ^ true, this.isMaximum);
        }
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.setJMenuBar(jMenuBar);
    }

    public void setNormalBounds(Rectangle rectangle) {
        this.storedBounds = rectangle;
    }

    public void setResizable(boolean bl) {
        if (bl != this.resizable) {
            this.resizable = bl;
            this.firePropertyChange("resizable", this.resizable ^ true, this.resizable);
        }
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        JRootPane jRootPane2 = this.rootPane;
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                Object var4_4 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
        this.firePropertyChange(ROOT_PANE_PROPERTY, jRootPane2, this.rootPane);
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        if (bl != this.isSelected && (!bl || (this.isIcon ? this.desktopIcon.isShowing() : this.isShowing()))) {
            this.fireVetoableChange(IS_SELECTED_PROPERTY, this.isSelected, bl);
            if (!bl) {
                this.defaultFocus = this.getMostRecentFocusOwner();
            }
            this.isSelected = bl;
            this.firePropertyChange(IS_SELECTED_PROPERTY, this.isSelected ^ true, this.isSelected);
            if (this.isSelected) {
                this.fireInternalFrameEvent(25554);
            } else {
                this.fireInternalFrameEvent(25555);
            }
            if (bl) {
                this.restoreSubcomponentFocus();
            }
            this.repaint();
        }
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange(TITLE_PROPERTY, string2, this.title);
    }

    public void show() {
        if (!this.isVisible()) {
            if (this.isFirstTimeVisible) {
                this.isFirstTimeVisible = false;
                this.fireInternalFrameEvent(25549);
            }
            this.getDesktopIcon().setVisible(true);
            this.toFront();
            super.show();
            if (this.isIcon()) {
                return;
            }
            if (!this.isSelected()) {
                try {
                    this.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public void setUI(InternalFrameUI internalFrameUI) {
        boolean bl = this.isRootPaneCheckingEnabled();
        this.setRootPaneCheckingEnabled(false);
        super.setUI(internalFrameUI);
        this.setRootPaneCheckingEnabled(bl);
    }

    public void toBack() {
        this.moveToBack();
    }

    public void toFront() {
        this.moveToFront();
    }

    public void updateUI() {
        boolean bl = this.isRootPaneCheckingEnabled();
        this.setRootPaneCheckingEnabled(false);
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.setRootPaneCheckingEnabled(bl);
    }

    void setWasIcon(boolean bl, String string) {
        if (bl && !this.wasIcon) {
            this.wasIcon = bl;
            this.firePropertyChange(string, bl ^ true, bl);
        }
    }

    boolean getWasIcon() {
        return this.wasIcon;
    }

    private void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        super.fireVetoableChange(string, bl, bl2);
    }

    public static class JDesktopIcon
    extends JComponent
    implements Accessible {
        private static final long serialVersionUID = 4672973344731387687L;
        JInternalFrame frame;

        public JDesktopIcon(JInternalFrame jInternalFrame) {
            this.frame = jInternalFrame;
            this.updateUI();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJDesktopIcon(this);
            }
            return this.accessibleContext;
        }

        public JDesktopPane getDesktopPane() {
            JDesktopPane jDesktopPane = (JDesktopPane)SwingUtilities.getAncestorOfClass(JInternalFrame.class$("javax.swing.JDesktopPane"), this);
            return jDesktopPane;
        }

        public JInternalFrame getInternalFrame() {
            return this.frame;
        }

        public DesktopIconUI getUI() {
            return (DesktopIconUI)this.ui;
        }

        public String getUIClassID() {
            return "DesktopIconUI";
        }

        public void setInternalFrame(JInternalFrame jInternalFrame) {
            this.frame = jInternalFrame;
        }

        public void setUI(DesktopIconUI desktopIconUI) {
            super.setUI(desktopIconUI);
        }

        public void updateUI() {
            this.setUI((DesktopIconUI)UIManager.getUI(this));
        }

        protected class AccessibleJDesktopIcon
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            private /* synthetic */ JDesktopIcon this$1;
            private static final long serialVersionUID = 5035560458941637802L;

            protected AccessibleJDesktopIcon(JDesktopIcon jDesktopIcon) {
                this.this$1 = jDesktopIcon;
                super(jDesktopIcon);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.DESKTOP_ICON;
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                return new Integer(this.this$1.frame.getLayer());
            }

            public Number getMaximumAccessibleValue() {
                return new Integer(Integer.MAX_VALUE);
            }

            public Number getMinimumAccessibleValue() {
                return new Integer(Integer.MIN_VALUE);
            }

            public boolean setCurrentAccessibleValue(Number number) {
                if (number == null) {
                    return false;
                }
                this.this$1.frame.setLayer(number.intValue());
                return true;
            }
        }
    }

    protected class AccessibleJInternalFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JInternalFrame this$0;
        private static final long serialVersionUID = 5931936924175476797L;

        protected AccessibleJInternalFrame(JInternalFrame jInternalFrame) {
            this.this$0 = jInternalFrame;
            super(jInternalFrame);
        }

        public String getAccessibleName() {
            return this.this$0.getTitle();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.INTERNAL_FRAME;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(this.this$0.getLayer());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Integer.MAX_VALUE);
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Integer.MIN_VALUE);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number == null) {
                return false;
            }
            this.this$0.setLayer(number.intValue());
            return true;
        }
    }
}

