/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class EtchedBorder
extends AbstractBorder {
    static final long serialVersionUID = 4001244046866360638L;
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int etchType;
    protected Color highlight;
    protected Color shadow;

    public EtchedBorder() {
        this(1);
    }

    public EtchedBorder(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.etchType = n;
    }

    public EtchedBorder(Color color, Color color2) {
        this(1, color, color2);
    }

    public EtchedBorder(int n, Color color, Color color2) {
        this(n);
        this.highlight = color;
        this.shadow = color2;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.etchType) {
            case 0: {
                EtchedBorder.paintEtchedBorder(graphics, n, n2, n3, n4, this.getHighlightColor(component), this.getShadowColor(component));
                break;
            }
            case 1: {
                EtchedBorder.paintEtchedBorder(graphics, n, n2, n3, n4, this.getShadowColor(component), this.getHighlightColor(component));
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(2, 2, 2, 2);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.bottom = 2;
        insets.top = 2;
        insets.right = 2;
        insets.left = 2;
        return insets;
    }

    public boolean isBorderOpaque() {
        return !(this.highlight != null && this.highlight.getAlpha() != 255 || this.shadow != null && this.shadow.getAlpha() != 255);
    }

    public int getEtchType() {
        return this.etchType;
    }

    public Color getHighlightColor(Component component) {
        if (this.highlight != null) {
            return this.highlight;
        }
        return component.getBackground().brighter();
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor(Component component) {
        if (this.shadow != null) {
            return this.shadow;
        }
        return component.getBackground().darker();
    }

    public Color getShadowColor() {
        return this.shadow;
    }

    private static void paintEtchedBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.translate(n, n2);
        --n3;
        --n4;
        try {
            graphics.setColor(color);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(color2);
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.drawLine(1, 2, 1, n4 - 2);
            graphics.drawLine(0, n4, n3, n4);
            graphics.drawLine(n3, 0, n3, n4 - 1);
        }
        finally {
            Object var8_8 = null;
            graphics.translate(-n, -n2);
            graphics.setColor(color3);
        }
    }
}

