/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.jar.Action;
import gnu.classpath.tools.jar.Main;
import gnu.classpath.tools.jar.WorkSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Lister
extends Action {
    private WorkSet allItems;

    private long readUntilEnd(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[5120];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            l += (long)n;
        }
        return l;
    }

    private void listJar(ZipInputStream zipInputStream, boolean bl) throws IOException {
        ZipEntry zipEntry;
        MessageFormat messageFormat = null;
        if (bl) {
            messageFormat = new MessageFormat(" {0,date,E M dd HH:mm:ss z yyyy} {1}");
        }
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!this.allItems.contains(zipEntry.getName())) continue;
            if (bl) {
                long l = this.readUntilEnd(zipInputStream);
                String string = "     " + l;
                int n = Math.min(string.length() - 5, 5);
                System.out.print(string.substring(n));
                Object[] objectArray = new Object[]{new Date(zipEntry.getTime()), zipEntry.getName()};
                System.out.println(messageFormat.format(objectArray));
                continue;
            }
            System.out.println(zipEntry.getName());
        }
    }

    public void run(Main main) throws IOException {
        this.allItems = new WorkSet(main.entries);
        File file = main.archiveFile;
        ZipInputStream zipInputStream = file == null || "-".equals(file.getName()) ? new ZipInputStream(System.in) : new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.listJar(zipInputStream, main.verbose);
    }
}

