#!/bin/sh
echo 'name: haskell-src-exts
version: 1.9.6
id: haskell-src-exts-1.9.6-c85742146ae79b393bc1412f0afc99eb

license: BSD3
copyright:
maintainer: Niklas Broberg <d00nibro@chalmers.se>
stability: Stable
homepage: http://code.haskell.org/haskell-src-exts
package-url:
description: Haskell-Source with Extensions (HSE, haskell-src-exts)
             is an extension of the standard haskell-src package,
             and handles most registered syntactic extensions to Haskell, including:
             .
             * Multi-parameter type classes with functional dependencies
             .
             * Indexed type families (including associated types)
             .
             * Empty data declarations
             .
             * GADTs
             .
             * Implicit parameters
             .
             * Template Haskell
             .
             and a few more. All extensions implemented in GHC are supported.
             Apart from these standard extensions,
             it also handles regular patterns as per the HaRP extension
             as well as HSX-style embedded XML syntax.
category: Language
author: Niklas Broberg
pkgpath: lang/hs-haskell-src-exts
exposed: True
exposed-modules: Language.Haskell.Exts Language.Haskell.Exts.Parser
                 Language.Haskell.Exts.Pretty Language.Haskell.Exts.Syntax
                 Language.Haskell.Exts.Extension Language.Haskell.Exts.Build
                 Language.Haskell.Exts.Fixity Language.Haskell.Exts.Comments
                 Language.Haskell.Exts.SrcLoc Language.Haskell.Exts.Annotated
                 Language.Haskell.Exts.Annotated.Syntax
                 Language.Haskell.Exts.Annotated.Fixity
                 Language.Haskell.Exts.Annotated.Build
                 Language.Haskell.Exts.Annotated.ExactPrint
                 Language.Haskell.Exts.Annotated.Simplify
hidden-modules: Language.Haskell.Exts.ExtScheme
                Language.Haskell.Exts.ParseMonad Language.Haskell.Exts.ParseSyntax
                Language.Haskell.Exts.Lexer Language.Haskell.Exts.ParseUtils
                Language.Haskell.Exts.InternalParser
import-dirs: /usr/local/lib/ghc/haskell-src-exts-1.9.6
library-dirs: /usr/local/lib/ghc/haskell-src-exts-1.9.6
hs-libraries: HShaskell-src-exts-1.9.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.1-d386e6865e2443d798e250f58dda005d
         base-4.2.0.2-af431bb15643ef1ce2792a51c33968b3
         cpphs-1.11-cf01a2a66c74eda22f00b65b41a768d6
         pretty-1.0.1.1-b6652d4fb1f996119a76dcaa986e9d70
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-haskell-src-exts-1.9.6/html/haskell-src-exts.haddock
haddock-html: /usr/local/share/doc/hs-haskell-src-exts-1.9.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
