/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.cvsSupport2.changeBrowser.CvsChangeList;
import com.intellij.cvsSupport2.changeBrowser.LogInformationWrapper;
import com.intellij.cvsSupport2.changeBrowser.RevisionWrapper;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.log.Revision;
import org.netbeans.lib.cvsclient.command.log.SymbolicName;

public class CvsChangeListsBuilder {
    @NonNls
    private static final String INITIALLY_ADDED_ON_BRANCH = "was initially added on branch";
    @NonNls
    private static final String ATTIC_SUFFIX = "/Attic";
    private final Map<ChangeListKey, List<CvsChangeList>> myCache = new HashMap<ChangeListKey, List<CvsChangeList>>();
    private long myLastNumber = 0L;
    private final String myRootPath;
    private final CvsEnvironment myEnvironment;
    private final Project myProject;
    private final VirtualFile myRootFile;

    public CvsChangeListsBuilder(String rootPath, CvsEnvironment environment, Project project, VirtualFile rootFile) {
        this.myRootPath = rootPath;
        this.myEnvironment = environment;
        this.myProject = project;
        this.myRootFile = rootFile;
    }

    public List<CvsChangeList> getVersions() {
        ArrayList<CvsChangeList> result = new ArrayList<CvsChangeList>();
        for (List<CvsChangeList> versions : this.myCache.values()) {
            result.addAll(versions);
        }
        return result;
    }

    public CvsChangeList addRevision(RevisionWrapper revision) {
        Revision cvsRevision = revision.getRevision();
        CvsChangeList version = this.findOrCreateVersionFor(cvsRevision.getMessage(), revision.getTime(), cvsRevision.getAuthor(), revision.getBranch(), revision.getFile());
        version.addFileRevision(revision);
        return version;
    }

    private CvsChangeList findOrCreateVersionFor(String message, long date, String author, String branch, String path) {
        CvsChangeList lastVersion;
        ChangeListKey key = new ChangeListKey(branch, author, message);
        List<CvsChangeList> versions = this.myCache.get(key);
        if (versions != null && (lastVersion = versions.get(versions.size() - 1)).containsDate(date) && !lastVersion.containsFile(path)) {
            return lastVersion;
        }
        CvsChangeList result = new CvsChangeList(this.myProject, this.myEnvironment, this.myRootFile, this.myLastNumber, message, date, author, this.myRootPath);
        ++this.myLastNumber;
        if (!this.myCache.containsKey(key)) {
            this.myCache.put(key, new ArrayList());
        }
        this.myCache.get(key).add(result);
        return result;
    }

    @Nullable
    public List<RevisionWrapper> revisionWrappersFromLog(LogInformationWrapper log) {
        LinkedList<RevisionWrapper> result = new LinkedList<RevisionWrapper>();
        String file = log.getFile();
        if (CvsChangeList.isAncestor(this.myRootPath, file)) {
            for (Revision revision : log.getRevisions()) {
                if (revision == null || revision.getState().equals("dead") && revision.getMessage().indexOf(INITIALLY_ADDED_ON_BRANCH) >= 0) continue;
                String branchName = CvsChangeListsBuilder.getBranchName(revision, log.getSymbolicNames());
                result.add(new RevisionWrapper(CvsChangeListsBuilder.stripAttic(file), revision, branchName));
            }
            return result;
        }
        return null;
    }

    public void addLogs(List<LogInformationWrapper> logs) {
        ArrayList<RevisionWrapper> revisionWrappers = new ArrayList<RevisionWrapper>();
        for (LogInformationWrapper log : logs) {
            List<RevisionWrapper> wrappers = this.revisionWrappersFromLog(log);
            if (wrappers == null) continue;
            revisionWrappers.addAll(wrappers);
        }
        Collections.sort(revisionWrappers);
        for (RevisionWrapper revisionWrapper : revisionWrappers) {
            this.addRevision(revisionWrapper);
        }
    }

    private static String stripAttic(String file) {
        String path;
        int pos = file.lastIndexOf(47);
        if (pos >= 0 && (path = file.substring(0, pos)).endsWith(ATTIC_SUFFIX)) {
            return path.substring(0, path.length() - 6) + file.substring(pos);
        }
        return file;
    }

    @Nullable
    private static String getBranchName(Revision revision, List<SymbolicName> symbolicNames) {
        String branches;
        CvsRevisionNumber number = new CvsRevisionNumber(revision.getNumber().trim());
        int[] subRevisions = number.getSubRevisions();
        String branchName = null;
        String branchNumberString = null;
        if (subRevisions != null && subRevisions.length >= 4) {
            int branchRevNumber = subRevisions[subRevisions.length - 2];
            CvsRevisionNumber branchNumber = number.removeTailVersions(2).addTailVersions(new int[]{0, branchRevNumber});
            branchNumberString = branchNumber.asString();
        }
        if (branchNumberString == null && (branches = revision.getBranches()) != null && branches.length() > 0) {
            String[] branchNames = branches.split(";");
            CvsRevisionNumber revisionNumber = new CvsRevisionNumber(branchNames[0].trim());
            int[] branchSubRevisions = revisionNumber.getSubRevisions();
            assert (branchSubRevisions != null);
            int rev = branchSubRevisions[branchSubRevisions.length - 1];
            CvsRevisionNumber branchNumber = revisionNumber.removeTailVersions(1).addTailVersions(new int[]{0, rev});
            branchNumberString = branchNumber.asString();
        }
        if (branchNumberString != null) {
            for (SymbolicName name : symbolicNames) {
                if (!name.getRevision().equals(branchNumberString)) continue;
                branchName = name.getName();
                break;
            }
        }
        return branchName;
    }

    private static class ChangeListKey {
        public String branch;
        public String author;
        public String message;

        public ChangeListKey(String branch, String author, String message) {
            this.branch = branch;
            this.author = author;
            this.message = message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeListKey that = (ChangeListKey)o;
            if (!this.author.equals(that.author)) {
                return false;
            }
            if (this.branch != null ? !this.branch.equals(that.branch) : that.branch != null) {
                return false;
            }
            return this.message.equals(that.message);
        }

        public int hashCode() {
            int result = this.branch != null ? this.branch.hashCode() : 0;
            result = 31 * result + this.author.hashCode();
            result = 31 * result + this.message.hashCode();
            return result;
        }
    }
}

