/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import gnu.trove.THashMap;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchPanel;
import org.jetbrains.idea.maven.project.MavenId;

public class MavenArtifactSearchDialog
extends DialogWrapper {
    private MavenId myResult;
    private JTabbedPane myTabbedPane;
    private MavenArtifactSearchPanel myArtifactsPanel;
    private MavenArtifactSearchPanel myClassesPanel;
    private final Map<MavenArtifactSearchPanel, Boolean> myOkButtonStates = new THashMap();

    public static MavenId searchForClass(Project project, String className) {
        MavenArtifactSearchDialog d = new MavenArtifactSearchDialog(project, className, true);
        d.show();
        if (!d.isOK()) {
            return null;
        }
        return d.getResult();
    }

    public static MavenId searchForArtifact(Project project) {
        MavenArtifactSearchDialog d = new MavenArtifactSearchDialog(project, "", false);
        d.show();
        if (!d.isOK()) {
            return null;
        }
        return d.getResult();
    }

    private MavenArtifactSearchDialog(Project project, String initialText, boolean classMode) {
        super(project, true);
        this.initComponents(project, initialText, classMode);
        this.setTitle("Maven Artifact Search");
        this.updateOkButtonState();
        this.init();
        this.myArtifactsPanel.scheduleSearch();
        this.myClassesPanel.scheduleSearch();
    }

    private void initComponents(Project project, String initialText, boolean classMode) {
        this.myTabbedPane = new JTabbedPane(1);
        MavenArtifactSearchPanel.Listener l = new MavenArtifactSearchPanel.Listener(){

            @Override
            public void doubleClicked() {
                MavenArtifactSearchDialog.this.clickDefaultButton();
            }

            @Override
            public void canSelectStateChanged(MavenArtifactSearchPanel from, boolean canSelect) {
                MavenArtifactSearchDialog.this.myOkButtonStates.put(from, canSelect);
                MavenArtifactSearchDialog.this.updateOkButtonState();
            }
        };
        this.myArtifactsPanel = new MavenArtifactSearchPanel(project, !classMode ? initialText : "", false, l, this.getDisposable());
        this.myClassesPanel = new MavenArtifactSearchPanel(project, classMode ? initialText : "", true, l, this.getDisposable());
        this.myTabbedPane.addTab("Search for artifact", this.myArtifactsPanel);
        this.myTabbedPane.addTab("Search for class", this.myClassesPanel);
        this.myTabbedPane.setSelectedIndex(classMode ? 1 : 0);
        this.myTabbedPane.setMnemonicAt(0, 65);
        this.myTabbedPane.setDisplayedMnemonicIndexAt(0, this.myTabbedPane.getTitleAt(0).indexOf("artifact"));
        this.myTabbedPane.setMnemonicAt(1, 67);
        this.myTabbedPane.setDisplayedMnemonicIndexAt(1, this.myTabbedPane.getTitleAt(1).indexOf("class"));
        this.myTabbedPane.setPreferredSize(new Dimension(600, 400));
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MavenArtifactSearchDialog.this.updateOkButtonState();
            }
        });
        this.updateOkButtonState();
    }

    private void updateOkButtonState() {
        Boolean canSelect = this.myOkButtonStates.get(this.myTabbedPane.getSelectedComponent());
        if (canSelect == null) {
            canSelect = false;
        }
        this.setOKActionEnabled(canSelect);
    }

    protected Action getOKAction() {
        Action result = super.getOKAction();
        result.putValue("Name", "Add");
        return result;
    }

    protected JComponent createCenterPanel() {
        return this.myTabbedPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTabbedPane.getSelectedIndex() == 0 ? this.myArtifactsPanel.getSearchField() : this.myClassesPanel.getSearchField();
    }

    protected String getDimensionServiceKey() {
        return "Maven.ArtifactSearchDialog";
    }

    public MavenId getResult() {
        return this.myResult;
    }

    protected void doOKAction() {
        MavenArtifactSearchPanel panel = this.myTabbedPane.getSelectedIndex() == 0 ? this.myArtifactsPanel : this.myClassesPanel;
        this.myResult = panel.getResult();
        super.doOKAction();
    }
}

