/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.config;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.generate.tostring.config.InsertNewMethodStrategy;

public class InsertAtCaretStrategy
implements InsertNewMethodStrategy {
    private static final InsertAtCaretStrategy instance = new InsertAtCaretStrategy();

    private InsertAtCaretStrategy() {
    }

    public static InsertAtCaretStrategy getInstance() {
        return instance;
    }

    @Override
    public PsiMethod insertNewMethod(PsiClass clazz, @NotNull PsiMethod newMethod, Editor editor) throws IncorrectOperationException {
        if (newMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/generate/tostring/config/InsertAtCaretStrategy.insertNewMethod must not be null");
        }
        int offset = editor != null ? editor.getCaretModel().getOffset() : clazz.getTextRange().getEndOffset() - 1;
        PsiGenerationInfo generationInfo = new PsiGenerationInfo((PsiMember)newMethod, false);
        GenerateMembersUtil.insertMembersAtOffset((PsiFile)clazz.getContainingFile(), (int)offset, Arrays.asList(generationInfo));
        return (PsiMethod)generationInfo.getPsiMember();
    }

    public String toString() {
        return "At caret";
    }
}

