/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.impl.ConcatenationToMessageFormatAction;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeConcatenationQuickFix;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class I18nizeAction
extends AnAction
implements I18nQuickFixHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.i18n.I18nizeAction");

    public void update(AnActionEvent e) {
        boolean active;
        boolean bl = active = this.getHandler(e) != null;
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(active);
        } else {
            e.getPresentation().setEnabled(active);
        }
    }

    @Nullable
    public I18nQuickFixHandler getHandler(AnActionEvent e) {
        Editor editor = I18nizeAction.getEditor(e);
        if (editor == null) {
            return null;
        }
        PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiLiteralExpression literalExpression = I18nizeAction.getEnclosingStringLiteral(psiFile, editor);
        TextRange range = I18nizeAction.getSelectedRange(I18nizeAction.getEditor(e), psiFile);
        PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        if (range != null && ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation((PsiElement)element) != null) {
            return new I18nizeConcatenationQuickFix();
        }
        if (literalExpression != null && range != null && literalExpression.getTextRange().contains(range)) {
            return new I18nizeQuickFix();
        }
        if (psiFile instanceof JspFile && range != null) {
            return this;
        }
        return null;
    }

    @Override
    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        if (!I18nizeAction.canBeExtractedAway((JspFile)psiFile, editor)) {
            throw new IncorrectOperationException(CodeInsightBundle.message((String)"i18nize.jsp.error", (Object[])new Object[0]));
        }
    }

    @Override
    public void performI18nization(PsiFile psiFile, Editor editor, PsiLiteralExpression literalExpression, Collection<PropertiesFile> propertiesFiles, String key, String value, String i18nizedText, PsiExpression[] parameters, PropertyCreationHandler propertyCreationHandler) throws IncorrectOperationException {
        Project project = psiFile.getProject();
        TextRange selectedText = I18nizeAction.getSelectedRange(editor, psiFile);
        if (selectedText == null) {
            return;
        }
        propertyCreationHandler.createProperty(project, propertiesFiles, key, value, parameters);
        editor.getDocument().replaceString(selectedText.getStartOffset(), selectedText.getEndOffset(), (CharSequence)i18nizedText);
    }

    public static PsiLiteralExpression getEnclosingStringLiteral(PsiFile psiFile, Editor editor) {
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null) {
            return null;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiLiteralExpression.class);
        if (expression == null || !(expression.getValue() instanceof String)) {
            return null;
        }
        return expression;
    }

    private static boolean canBeExtractedAway(final JspFile jspFile, Editor editor) {
        final TextRange selectedRange = I18nizeAction.getSelectedRange(editor, (PsiFile)jspFile);
        final Ref result = new Ref((Object)Boolean.TRUE);
        PsiFile root = jspFile.getBaseLanguageRoot();
        root.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!((Boolean)result.get()).booleanValue()) {
                    return;
                }
                TextRange elementRange = element.getTextRange();
                if (elementRange.intersectsStrict(selectedRange) && (jspFile.getLanguage() != StdLanguages.JSPX && element instanceof OuterLanguageElement || element instanceof XmlTag && !selectedRange.contains(elementRange) && (!elementRange.contains(selectedRange) || !((XmlTag)element).getValue().getTextRange().contains(selectedRange)))) {
                    result.set((Object)Boolean.FALSE);
                    return;
                }
                super.visitElement(element);
            }
        });
        return (Boolean)result.get();
    }

    @Nullable
    private static TextRange getSelectedRange(Editor editor, PsiFile psiFile) {
        if (editor == null) {
            return null;
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        if (selectedText != null) {
            return new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        }
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null || psiElement instanceof PsiWhiteSpace) {
            return null;
        }
        return psiElement.getTextRange();
    }

    private static Editor getEditor(AnActionEvent e) {
        return (Editor)PlatformDataKeys.EDITOR.getData(e.getDataContext());
    }

    public void actionPerformed(AnActionEvent e) {
        final Editor editor = I18nizeAction.getEditor(e);
        final Project project = editor.getProject();
        final PsiFile psiFile = (PsiFile)LangDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile == null) {
            return;
        }
        final I18nQuickFixHandler handler = this.getHandler(e);
        if (handler == null) {
            return;
        }
        try {
            handler.checkApplicability(psiFile, editor);
        }
        catch (IncorrectOperationException ex) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)ex.getMessage(), (String)CodeInsightBundle.message((String)"i18nize.error.title", (Object[])new Object[0]), null);
            return;
        }
        final JavaI18nizeQuickFixDialog dialog = handler.createDialog(project, editor, psiFile);
        if (dialog == null) {
            return;
        }
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        if (!CodeInsightUtilBase.prepareFileForWrite((PsiFile)psiFile)) {
            return;
        }
        final Collection propertiesFiles = dialog.getAllPropertiesFiles();
        for (PropertiesFile file : propertiesFiles) {
            if (CodeInsightUtilBase.prepareFileForWrite((PsiFile)file)) continue;
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            handler.performI18nization(psiFile, editor, dialog.getLiteralExpression(), propertiesFiles, dialog.getKey(), dialog.getValue(), dialog.getI18nizedText(), dialog.getParameters(), dialog.getPropertyCreationHandler());
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }, CodeInsightBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project);
            }
        });
    }

    @Override
    public JavaI18nizeQuickFixDialog createDialog(Project project, Editor editor, PsiFile psiFile) {
        JspFile jspFile = (JspFile)psiFile;
        TextRange selectedRange = I18nizeAction.getSelectedRange(editor, psiFile);
        if (selectedRange == null) {
            return null;
        }
        String text = selectedRange.substring(editor.getDocument().getText());
        return new JavaI18nizeQuickFixDialog(project, (PsiFile)jspFile, null, text, null, false, true){

            @Override
            protected String getTemplateName() {
                return "I18nized JSP Expression.jsp";
            }
        };
    }
}

