/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareToUsesNonFinalVariableInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.final.field.compareto.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CompareToUsesNonFinalVariableInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.final.field.compareto.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CompareToUsesNonFinalVariableInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CompareToUsesNonFinalVariableVisitor();
    }

    private static class CompareToUsesNonFinalVariableVisitor
    extends BaseInspectionVisitor {
        private CompareToUsesNonFinalVariableVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CompareToUsesNonFinalVariableInspection$CompareToUsesNonFinalVariableVisitor.visitMethod must not be null");
            }
            boolean isCompareTo = MethodUtils.isCompareTo(method);
            if (isCompareTo) {
                method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                        if (expression == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CompareToUsesNonFinalVariableInspection$CompareToUsesNonFinalVariableVisitor$1.visitReferenceExpression must not be null");
                        }
                        super.visitReferenceExpression(expression);
                        PsiElement element = expression.resolve();
                        if (!(element instanceof PsiField)) {
                            return;
                        }
                        PsiField field = (PsiField)element;
                        if (field.hasModifierProperty("final")) {
                            return;
                        }
                        CompareToUsesNonFinalVariableVisitor.this.registerError((PsiElement)expression, new Object[]{field});
                    }
                });
            }
        }
    }
}

