/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClassInitializer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInitializerInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("NonStaticInitializer" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassInitializerInspection.getID must not return null");
        }
        return "NonStaticInitializer";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.initializer.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassInitializerInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.initializer.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassInitializerInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("static");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassInitializerVisitor();
    }

    private static class ClassInitializerVisitor
    extends BaseInspectionVisitor {
        private ClassInitializerVisitor() {
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            super.visitClassInitializer(initializer);
            if (initializer.hasModifierProperty("static")) {
                return;
            }
            this.registerClassInitializerError(initializer, new Object[0]);
        }
    }
}

