/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class StaticImportsAreUsedVisitor
extends JavaRecursiveElementVisitor {
    private final List<PsiImportStaticStatement> importStatements;

    StaticImportsAreUsedVisitor(PsiImportStaticStatement[] importStatements) {
        this.importStatements = new ArrayList<PsiImportStaticStatement>(Arrays.asList(importStatements));
        Collections.reverse(this.importStatements);
    }

    public void visitElement(PsiElement element) {
        if (this.importStatements.isEmpty()) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/imports/StaticImportsAreUsedVisitor.visitReferenceElement must not be null");
        }
        this.followReferenceToImport(reference);
        super.visitReferenceElement(reference);
    }

    private void followReferenceToImport(PsiJavaCodeReferenceElement reference) {
        if (reference.getQualifier() != null) {
            return;
        }
        String referenceName = reference.getReferenceName();
        if (referenceName == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (!(element instanceof PsiMember)) {
            return;
        }
        PsiMember member = (PsiMember)element;
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return;
        }
        for (PsiImportStaticStatement importStatement : this.importStatements) {
            if (importStatement.isOnDemand()) {
                PsiClass targetClass = importStatement.resolveTargetClass();
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)targetClass, (PsiClass)containingClass, (boolean)true)) continue;
                this.removeAll(importStatement);
                break;
            }
            String importReferenceName = importStatement.getReferenceName();
            if (importReferenceName == null || !importReferenceName.equals(referenceName)) continue;
            this.removeAll(importStatement);
            break;
        }
    }

    private void removeAll(@NotNull PsiImportStaticStatement importStaticStatement) {
        if (importStaticStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/imports/StaticImportsAreUsedVisitor.removeAll must not be null");
        }
        for (int i = this.importStatements.size() - 1; i >= 0; --i) {
            PsiImportStaticStatement statement = this.importStatements.get(i);
            String text = statement.getText();
            if (!importStaticStatement.getText().equals(text)) continue;
            this.importStatements.remove(i);
        }
    }

    public PsiImportStaticStatement[] getUnusedImportStaticStatements() {
        if (this.importStatements.isEmpty()) {
            return PsiImportStaticStatement.EMPTY_ARRAY;
        }
        return this.importStatements.toArray(new PsiImportStaticStatement[this.importStatements.size()]);
    }
}

