/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractMethodWithMissingImplementationsInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("abstract.method.with.missing.implementations.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/AbstractMethodWithMissingImplementationsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.method.with.missing.implementations.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/AbstractMethodWithMissingImplementationsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstactMethodWithMissingImplementationsVisitor();
    }

    private static class InheritorFinder
    implements Runnable {
        private final PsiClass aClass;
        private Collection<PsiClass> inheritors = null;

        InheritorFinder(PsiClass aClass) {
            this.aClass = aClass;
        }

        @Override
        public void run() {
            SearchScope searchScope = this.aClass.getUseScope();
            this.inheritors = ClassInheritorsSearch.search((PsiClass)this.aClass, (SearchScope)searchScope, (boolean)true).findAll();
        }

        public Collection<PsiClass> getInheritors() {
            ProgressManager progressManager = ProgressManager.getInstance();
            progressManager.runProcess((Runnable)this, null);
            return this.inheritors;
        }
    }

    private static class AbstactMethodWithMissingImplementationsVisitor
    extends BaseInspectionVisitor {
        private AbstactMethodWithMissingImplementationsVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!containingClass.isInterface() && !method.hasModifierProperty("abstract")) {
                return;
            }
            InheritorFinder inheritorFinder = new InheritorFinder(containingClass);
            for (PsiClass inheritor : inheritorFinder.getInheritors()) {
                if (inheritor.isInterface() || inheritor.hasModifierProperty("abstract") || AbstactMethodWithMissingImplementationsVisitor.hasMatchingImplementation(inheritor, method)) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }

        private static boolean hasMatchingImplementation(@NotNull PsiClass aClass, @NotNull PsiMethod method) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/AbstractMethodWithMissingImplementationsInspection$AbstactMethodWithMissingImplementationsVisitor.hasMatchingImplementation must not be null");
            }
            if (method == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/inheritance/AbstractMethodWithMissingImplementationsInspection$AbstactMethodWithMissingImplementationsVisitor.hasMatchingImplementation must not be null");
            }
            PsiMethod overridingMethod = AbstactMethodWithMissingImplementationsVisitor.findOverridingMethod(aClass, method);
            if (overridingMethod == null || overridingMethod.hasModifierProperty("static")) {
                return false;
            }
            if (!method.hasModifierProperty("packageLocal")) {
                return true;
            }
            PsiClass superClass = method.getContainingClass();
            PsiManager manager = overridingMethod.getManager();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            return facade.arePackagesTheSame((PsiElement)superClass, (PsiElement)aClass);
        }

        @Nullable
        private static PsiMethod findOverridingMethod(PsiClass aClass, @NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/inheritance/AbstractMethodWithMissingImplementationsInspection$AbstactMethodWithMissingImplementationsVisitor.findOverridingMethod must not be null");
            }
            PsiClass superClass = method.getContainingClass();
            if (aClass.equals(superClass)) {
                return null;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            MethodSignature signature = method.getSignature(substitutor);
            List pairs = aClass.findMethodsAndTheirSubstitutorsByName(signature.getName(), true);
            for (Pair pair : pairs) {
                PsiSubstitutor overridingSubstitutor;
                MethodSignature foundMethodSignature;
                PsiClass containingClass;
                PsiMethod overridingMethod = (PsiMethod)pair.first;
                if (overridingMethod.hasModifierProperty("abstract") || (containingClass = overridingMethod.getContainingClass()).isInterface() || !MethodSignatureUtil.isSubsignature((MethodSignature)signature, (MethodSignature)(foundMethodSignature = overridingMethod.getSignature(overridingSubstitutor = (PsiSubstitutor)pair.second))) || overridingMethod == method) continue;
                return overridingMethod;
            }
            return null;
        }
    }
}

