/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VariablePassedAsArgumentExcludedVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final PsiVariable variable;
    private final Set<String> excludes;
    private boolean passed;

    public VariablePassedAsArgumentExcludedVisitor(@NotNull PsiVariable variable, @NotNull Set<String> excludes) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor.<init> must not be null");
        }
        if (excludes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor.<init> must not be null");
        }
        this.passed = false;
        this.variable = variable;
        this.excludes = excludes;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor.visitElement must not be null");
        }
        if (!this.passed) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        PsiExpression[] arguments;
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor.visitMethodCallExpression must not be null");
        }
        if (this.passed) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiExpressionList argumentList = call.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            String name;
            PsiClass aClass;
            PsiMethod method;
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable) || (method = call.resolveMethod()) != null && (aClass = method.getContainingClass()) != null && this.excludes.contains(name = aClass.getQualifiedName())) continue;
            this.passed = true;
        }
    }

    public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
        PsiExpression[] arguments;
        if (newExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor.visitNewExpression must not be null");
        }
        if (this.passed) {
            return;
        }
        super.visitNewExpression(newExpression);
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            String name;
            PsiClass aClass;
            PsiMethod constructor;
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable) || (constructor = newExpression.resolveConstructor()) != null && (aClass = constructor.getContainingClass()) != null && this.excludes.contains(name = aClass.getQualifiedName())) continue;
            this.passed = true;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

