/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ConfusingOctalEscapeInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ConfusingOctalEscapeSequence" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ConfusingOctalEscapeInspection.getID must not return null");
        }
        return "ConfusingOctalEscapeSequence";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("confusing.octal.escape.sequence.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ConfusingOctalEscapeInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("confusing.octal.escape.sequence.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ConfusingOctalEscapeInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingOctalEscapeVisitor();
    }

    private static class ConfusingOctalEscapeVisitor
    extends BaseInspectionVisitor {
        private ConfusingOctalEscapeVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ConfusingOctalEscapeInspection$ConfusingOctalEscapeVisitor.visitLiteralExpression must not be null");
            }
            super.visitLiteralExpression(expression);
            if (!TypeUtils.expressionHasType("java.lang.String", (PsiExpression)expression)) {
                return;
            }
            String text = expression.getText();
            if (!ConfusingOctalEscapeVisitor.containsConfusingOctalEscape(text)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean containsConfusingOctalEscape(String text) {
            int escapeStart = -1;
            while (true) {
                int digitPosition;
                int nextChar;
                if ((escapeStart = text.indexOf(92, escapeStart + 1)) < 0) {
                    return false;
                }
                if (escapeStart > 0 && text.charAt(escapeStart - 1) == '\\') continue;
                boolean isEscape = true;
                int textLength = text.length();
                for (nextChar = escapeStart + 1; nextChar < textLength && text.charAt(nextChar) == '\\'; ++nextChar) {
                    isEscape = !isEscape;
                }
                if (!isEscape) continue;
                escapeStart = nextChar - 1;
                for (digitPosition = escapeStart + 1; digitPosition < textLength && Character.isDigit(text.charAt(digitPosition)); ++digitPosition) {
                }
                if (digitPosition <= escapeStart + 1) continue;
                String escapeString = text.substring(escapeStart + 1, digitPosition);
                if (escapeString.length() > 3) {
                    return true;
                }
                if (escapeString.indexOf(56) > 0 || escapeString.indexOf(57) > 0) break;
            }
            return true;
        }
    }
}

