/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.DiffRange;
import com.intellij.util.diff.Diff;
import java.util.LinkedList;
import java.util.List;

public class DiffFragmentBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.DiffFragmentBuilder");
    private final String[] mySource1;
    private final String[] mySource2;
    private int myLastLine1 = 1;
    private int myLastLine2 = 1;
    private final List<DiffFragment> myData = new LinkedList<DiffFragment>();

    public DiffFragmentBuilder(String[] source1, String[] source2) {
        this.mySource1 = source1;
        this.mySource2 = source2;
        this.init();
    }

    private DiffFragment[] getFragments() {
        return this.myData.toArray(new DiffFragment[this.myData.size()]);
    }

    private void finish() {
        String text1 = null;
        String text2 = null;
        if (this.myLastLine1 <= this.mySource1.length) {
            text1 = this.concatinate(this.mySource1, this.myLastLine1, this.mySource1.length);
        }
        if (this.myLastLine2 <= this.mySource2.length) {
            text2 = this.concatinate(this.mySource2, this.myLastLine2, this.mySource2.length);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
    }

    private void init() {
        this.myData.clear();
        this.myLastLine2 = 1;
        this.myLastLine1 = 1;
    }

    private void append(int line, Range range) {
        LOG.debug("DiffFragmentBuilder.append(" + line + "," + range + "), modified:");
        String text1 = null;
        String text2 = null;
        int start = range.getStart();
        int end = range.getEnd();
        if (this.myLastLine1 <= line) {
            text1 = this.concatinate(this.mySource1, this.myLastLine1, line);
        }
        if (this.myLastLine2 < start) {
            text2 = this.concatinate(this.mySource2, this.myLastLine2, start - 1);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
        this.myData.add(new DiffFragment(null, this.concatinate(this.mySource2, start, end)));
        this.myLastLine1 = line + 1;
        this.myLastLine2 = end + 1;
    }

    private void change(Range range1, Range range2) {
        LOG.debug("DiffFragmentBuilder.change(" + range1 + "," + range2 + ")");
        String text1 = null;
        String text2 = null;
        int start1 = range1.getStart();
        int end1 = range1.getEnd();
        int start2 = range2.getStart();
        int end2 = range2.getEnd();
        if (this.myLastLine1 < start1) {
            text1 = this.concatinate(this.mySource1, this.myLastLine1, start1 - 1);
        }
        if (this.myLastLine2 < start2) {
            text2 = this.concatinate(this.mySource2, this.myLastLine2, start2 - 1);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
        this.myData.add(new DiffFragment(this.concatinate(this.mySource1, start1, end1), this.concatinate(this.mySource2, start2, end2)));
        this.myLastLine1 = end1 + 1;
        this.myLastLine2 = end2 + 1;
    }

    private void delete(Range range, int line) {
        LOG.debug("DiffFragmentBuilder.delete(" + range + "," + line + ")");
        String text1 = null;
        String text2 = null;
        int start = range.getStart();
        int end = range.getEnd();
        if (this.myLastLine1 < start) {
            text1 = this.concatinate(this.mySource1, this.myLastLine1, start - 1);
        }
        if (this.myLastLine2 <= line) {
            text2 = this.concatinate(this.mySource2, this.myLastLine2, line);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
        this.myData.add(new DiffFragment(this.concatinate(this.mySource1, start, end), null));
        this.myLastLine1 = end + 1;
        this.myLastLine2 = line + 1;
    }

    private String concatinate(String[] strings, int start, int end) {
        StringBuffer buffer = new StringBuffer();
        for (int i = start - 1; i < end; ++i) {
            buffer.append(strings[i]);
        }
        return buffer.toString();
    }

    public static DiffFragment[] buildFragments(DiffFragmentBuilder builder, Diff.Change change) {
        while (change != null) {
            if (change.inserted > 0 && change.deleted > 0) {
                builder.change(new DiffRange(change.line0 + 1, change.line0 + change.deleted), new DiffRange(change.line1 + 1, change.line1 + change.inserted));
            } else if (change.inserted > 0) {
                builder.append(change.line0, new DiffRange(change.line1 + 1, change.line1 + change.inserted));
            } else if (change.deleted > 0) {
                builder.delete(new DiffRange(change.line0 + 1, change.line0 + change.deleted), change.line1);
            }
            change = change.link;
        }
        builder.finish();
        return builder.getFragments();
    }

    public static interface Range {
        public int getStart();

        public int getEnd();
    }
}

