/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitBranch;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.StringScanner;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.update.GitBaseRebaseProcess;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class GitPushRebaseProcess
extends GitBaseRebaseProcess {
    private static final Logger LOG = Logger.getInstance((String)GitPushRebaseProcess.class.getName());
    private final boolean myAutoStash;
    private final Map<VirtualFile, List<String>> myReorderedCommits;
    private Set<VirtualFile> myRootsWithMerges;
    private Integer myRebaseEditorNo;
    private final GitRebaseEditorService myRebaseEditorService;

    public GitPushRebaseProcess(GitVcs vcs, Project project, List<VcsException> exceptions, boolean autoStash, Map<VirtualFile, List<String>> reorderedCommits, Set<VirtualFile> rootsWithMerges) {
        super(vcs, project, exceptions);
        this.myAutoStash = autoStash;
        this.myReorderedCommits = reorderedCommits;
        this.myRootsWithMerges = rootsWithMerges;
        this.myRebaseEditorService = GitRebaseEditorService.getInstance();
    }

    @Override
    protected GitLineHandler makeStartHandler(VirtualFile root) throws VcsException {
        List<String> commits = this.myReorderedCommits.get(root);
        boolean hasMerges = this.myRootsWithMerges.contains(root);
        GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
        if (commits != null || hasMerges) {
            h.addParameters("-i");
            PushRebaseEditor pushRebaseEditor = new PushRebaseEditor(root, commits, hasMerges, h);
            this.myRebaseEditorNo = pushRebaseEditor.getHandlerNo();
            this.myRebaseEditorService.configureHandler(h, this.myRebaseEditorNo);
            if (hasMerges) {
                h.addParameters("-p");
            }
        }
        h.addParameters("-m", "-v");
        GitBranch currentBranch = GitBranch.current(this.myProject, root);
        assert (currentBranch != null);
        GitBranch trackedBranch = currentBranch.tracked(this.myProject, root);
        assert (trackedBranch != null);
        h.addParameters(trackedBranch.getFullName());
        return h;
    }

    @Override
    protected void cleanupHandler(VirtualFile root, GitLineHandler h) {
        if (this.myRebaseEditorNo != null) {
            this.myRebaseEditorService.unregisterHandler(this.myRebaseEditorNo);
            this.myRebaseEditorNo = null;
        }
    }

    @Override
    protected void configureRebaseEditor(VirtualFile root, GitLineHandler h) {
        GitInteractiveRebaseEditorHandler editorHandler = new GitInteractiveRebaseEditorHandler(this.myRebaseEditorService, this.myProject, root, h);
        editorHandler.setRebaseEditorShown();
        this.myRebaseEditorNo = editorHandler.getHandlerNo();
        this.myRebaseEditorService.configureHandler(h, this.myRebaseEditorNo);
    }

    @Override
    protected String makeStashMessage() {
        return "Uncommitted changes before rebase operation in push dialog at " + DateFormat.getDateTimeInstance(3, 3, Locale.US).format(new Date());
    }

    @Override
    protected boolean isAutoStash() {
        return this.myAutoStash;
    }

    class PushRebaseEditor
    extends GitInteractiveRebaseEditorHandler {
        private List<String> myCommits;
        private boolean myHasMerges;

        public PushRebaseEditor(VirtualFile root, List<String> commits, boolean hasMerges, GitHandler h) {
            super(GitPushRebaseProcess.this.myRebaseEditorService, GitPushRebaseProcess.this.myProject, root, h);
            this.myCommits = commits;
            this.myHasMerges = hasMerges;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int editCommits(String path) {
            if (!this.myRebaseEditorShown) {
                this.myRebaseEditorShown = true;
                if (this.myHasMerges) {
                    return 0;
                }
                try {
                    TreeMap<String, String> pickLines = new TreeMap<String, String>();
                    StringScanner s = new StringScanner(new String(FileUtil.loadFileText((File)new File(path), (String)"UTF-8")));
                    while (s.hasMoreData()) {
                        if (!s.tryConsume("pick ")) {
                            s.line();
                            continue;
                        }
                        String commit = s.spaceToken();
                        pickLines.put(commit, "pick " + commit + " " + s.line());
                    }
                    PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));
                    try {
                        for (String commit : this.myCommits) {
                            String key = pickLines.headMap(commit + "\u0000").lastKey();
                            if (key == null || !commit.startsWith(key)) continue;
                            w.print((String)pickLines.get(key) + "\n");
                        }
                    }
                    finally {
                        w.close();
                    }
                    return 0;
                }
                catch (Exception ex) {
                    LOG.error("Editor failed: ", (Throwable)ex);
                    return 1;
                }
            }
            return super.editCommits(path);
        }
    }
}

