/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GitConfigUtil {
    private GitConfigUtil() {
    }

    public static void getValues(Project project, VirtualFile root, String keyMask, Map<String, String> result) throws VcsException {
        int pos;
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.CONFIG);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters("--null", "--get-regexp", keyMask);
        String output = h.run();
        int start = 0;
        while ((pos = output.indexOf(10, start)) != -1) {
            String key = output.substring(start, pos);
            start = pos + 1;
            if ((pos = output.indexOf(0, start)) == -1) break;
            String value = output.substring(start, pos);
            start = pos + 1;
            result.put(key, value);
        }
    }

    public static List<Pair<String, String>> getAllValues(Project project, VirtualFile root, @NonNls String key) throws VcsException {
        int pos;
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.CONFIG);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters("--null", "--get-all", key);
        String output = h.run();
        int start = 0;
        while ((pos = output.indexOf(0, start)) != -1) {
            String value = output.substring(start, pos);
            start = pos + 1;
            result.add((Pair<String, String>)new Pair((Object)key, (Object)value));
        }
        return result;
    }

    @Nullable
    public static String getValue(Project project, VirtualFile root, @NonNls String key) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.CONFIG);
        h.setNoSSH(true);
        h.setSilent(true);
        h.ignoreErrorCode(1);
        h.addParameters("--null", "--get", key);
        String output = h.run();
        int pos = output.indexOf(0);
        if (h.getExitCode() != 0 || pos == -1) {
            return null;
        }
        return output.substring(0, pos);
    }

    @Nullable
    public static Boolean getBoolValue(Project project, VirtualFile root, @NonNls String key) throws VcsException {
        String value = GitConfigUtil.getValue(project, root, key);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        if ("yes".equals(value) || "true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("no".equals(value) || "false".equals(value)) {
            return Boolean.FALSE;
        }
        try {
            int i = Integer.parseInt(value);
            return i != 0;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static String getCommitEncoding(Project project, VirtualFile root) {
        String encoding = null;
        try {
            encoding = GitConfigUtil.getValue(project, root, "i18n.commitencoding");
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        if (encoding == null || encoding.length() == 0) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public static String getLogEncoding(Project project, VirtualFile root) {
        String encoding = null;
        try {
            encoding = GitConfigUtil.getValue(project, root, "i18n.logoutputencoding");
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        if (encoding == null || encoding.length() == 0) {
            encoding = GitConfigUtil.getCommitEncoding(project, root);
        }
        return encoding;
    }

    public static String getFileNameEncoding() {
        return Charset.defaultCharset().name();
    }

    public static void unsetValue(Project project, VirtualFile root, String key) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.CONFIG);
        h.setNoSSH(true);
        h.setSilent(true);
        h.ignoreErrorCode(1);
        h.addParameters("--unset", key);
        h.run();
    }

    public static void setValue(Project project, VirtualFile root, String key, String value) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.CONFIG);
        h.setNoSSH(true);
        h.setSilent(true);
        h.ignoreErrorCode(1);
        h.addParameters(key, value);
        h.run();
    }
}

