/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class JavaIndentOptionsEditor
extends SmartIndentOptionsEditor {
    private JTextField myLabelIndent;
    private JLabel myLabelIndentLabel;
    private JCheckBox myLabelIndentAbsolute;
    private JCheckBox myCbDontIndentTopLevelMembers;

    protected void addComponents() {
        super.addComponents();
        this.myLabelIndent = new JTextField(4);
        this.myLabelIndentLabel = new JLabel(ApplicationBundle.message((String)"editbox.indent.label.indent", (Object[])new Object[0]));
        this.add(this.myLabelIndentLabel, this.myLabelIndent);
        this.myLabelIndentAbsolute = new JCheckBox(ApplicationBundle.message((String)"checkbox.indent.absolute.label.indent", (Object[])new Object[0]));
        this.add(this.myLabelIndentAbsolute, true);
        this.myCbDontIndentTopLevelMembers = new JCheckBox(ApplicationBundle.message((String)"checkbox.do.not.indent.top.level.class.members", (Object[])new Object[0]));
        this.add(this.myCbDontIndentTopLevelMembers);
    }

    public boolean isModified(CodeStyleSettings settings, CodeStyleSettings.IndentOptions options) {
        boolean isModified = super.isModified(settings, options);
        isModified |= JavaIndentOptionsEditor.isFieldModified((JTextField)this.myLabelIndent, (int)options.LABEL_INDENT_SIZE);
        isModified |= JavaIndentOptionsEditor.isFieldModified((JCheckBox)this.myLabelIndentAbsolute, (boolean)options.LABEL_INDENT_ABSOLUTE);
        return isModified |= JavaIndentOptionsEditor.isFieldModified((JCheckBox)this.myCbDontIndentTopLevelMembers, (boolean)settings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS);
    }

    public void apply(CodeStyleSettings settings, CodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        try {
            options.LABEL_INDENT_SIZE = Integer.parseInt(this.myLabelIndent.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        options.LABEL_INDENT_ABSOLUTE = this.myLabelIndentAbsolute.isSelected();
        settings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = this.myCbDontIndentTopLevelMembers.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/application/options/JavaIndentOptionsEditor.reset must not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/application/options/JavaIndentOptionsEditor.reset must not be null");
        }
        super.reset(settings, options);
        this.myLabelIndent.setText(Integer.toString(options.LABEL_INDENT_SIZE));
        this.myLabelIndentAbsolute.setSelected(options.LABEL_INDENT_ABSOLUTE);
        this.myCbDontIndentTopLevelMembers.setSelected(settings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myLabelIndent.setEnabled(enabled);
        this.myLabelIndentLabel.setEnabled(enabled);
        this.myLabelIndentAbsolute.setEnabled(enabled);
    }
}

