/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.GridLayout;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class LayoutProjectCodeDialog
extends DialogWrapper {
    @NonNls
    private static final String OPTIMIZE_IMPORTS_KEY = "LayoutCode.optimizeImports";
    @NonNls
    private static final String HELP_ID = "editing.codeReformatting";
    private final String myText;
    private final boolean mySuggestOptmizeImports;
    private JCheckBox myCbOptimizeImports;

    public LayoutProjectCodeDialog(Project project, String title, String text, boolean suggestOptmizeImports) {
        super(project, false);
        this.myText = text;
        this.mySuggestOptmizeImports = suggestOptmizeImports;
        this.setOKButtonText(CodeInsightBundle.message((String)"reformat.code.accept.button.text", (Object[])new Object[0]));
        this.setTitle(title);
        this.init();
    }

    protected JComponent createCenterPanel() {
        if (!this.mySuggestOptmizeImports) {
            return new JLabel(this.myText);
        }
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.add(new JLabel(this.myText));
        this.myCbOptimizeImports = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.optimize.imports", (Object[])new Object[0]));
        panel.add(this.myCbOptimizeImports);
        this.myCbOptimizeImports.setSelected(Boolean.toString(true).equals(PropertiesComponent.getInstance().getValue(OPTIMIZE_IMPORTS_KEY)));
        return panel;
    }

    private void setOptimizeImportsOption(boolean state) {
        PropertiesComponent.getInstance().setValue(OPTIMIZE_IMPORTS_KEY, Boolean.toString(state));
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.mySuggestOptmizeImports) {
            this.setOptimizeImportsOption(this.isOptimizeImports());
        }
    }

    public boolean isOptimizeImports() {
        return this.myCbOptimizeImports.isSelected();
    }
}

