/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.BaseExtResourceAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AddXsiSchemaLocationForExtResourceAction
extends BaseExtResourceAction {
    @NonNls
    private static final String XMLNS_XSI_ATTR_NAME = "xmlns:xsi";
    @NonNls
    private static final String XSI_SCHEMA_LOCATION_ATTR_NAME = "xsi:schemaLocation";

    @Override
    protected String getQuickFixKeyId() {
        return "add.xsi.schema.location.for.external.resource";
    }

    @Override
    protected void doInvoke(final @NotNull PsiFile file, int offset, final @NotNull String uri, final Editor editor) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction.doInvoke must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction.doInvoke must not be null");
        }
        final XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), XmlTag.class);
        if (tag == null) {
            return;
        }
        final ArrayList schemaLocations = new ArrayList();
        CreateNSDeclarationIntentionFix.processExternalUris(new CreateNSDeclarationIntentionFix.TagMetaHandler(tag.getLocalName()), file, new CreateNSDeclarationIntentionFix.ExternalUriProcessor(){

            @Override
            public void process(@NotNull String currentUri, String url) {
                if (currentUri == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction$1.process must not be null");
                }
                if (currentUri.equals(uri) && url != null) {
                    schemaLocations.add(url);
                }
            }
        }, true);
        CreateNSDeclarationIntentionFix.runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(ArrayUtil.toStringArray(schemaLocations), file.getProject(), new CreateNSDeclarationIntentionFix.StringToAttributeProcessor(){

            @Override
            public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NotNull String attrName) throws IncorrectOperationException {
                if (attrName == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction$2.doSomethingWithGivenStringToProduceXmlAttributeNowPlease must not be null");
                }
                AddXsiSchemaLocationForExtResourceAction.doIt(file, editor, uri, tag, attrName);
            }
        }, XmlErrorMessages.message("select.namespace.location.title", new Object[0]), (IntentionAction)this, editor);
    }

    private static void doIt(PsiFile file, Editor editor, String uri, XmlTag tag, String s) throws IncorrectOperationException {
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)file.getProject());
        if (tag.getAttributeValue(XMLNS_XSI_ATTR_NAME) == null) {
            tag.add((PsiElement)elementFactory.createXmlAttribute(XMLNS_XSI_ATTR_NAME, "http://www.w3.org/2001/XMLSchema-instance"));
        }
        XmlAttribute locationAttribute = tag.getAttribute(XSI_SCHEMA_LOCATION_ATTR_NAME);
        String toInsert = uri + " " + s;
        int offset = s.length();
        if (locationAttribute == null) {
            tag.add((PsiElement)elementFactory.createXmlAttribute(XSI_SCHEMA_LOCATION_ATTR_NAME, toInsert));
        } else {
            String newValue = locationAttribute.getValue() + "\n" + toInsert;
            locationAttribute.setValue(newValue);
        }
        CodeStyleManager.getInstance((Project)file.getProject()).reformat((PsiElement)tag);
        TextRange range = tag.getAttribute(XSI_SCHEMA_LOCATION_ATTR_NAME).getValueElement().getTextRange();
        TextRange textRange = new TextRange(range.getEndOffset() - offset - 1, range.getEndOffset() - 1);
        editor.getCaretModel().moveToOffset(textRange.getStartOffset());
    }
}

