/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.MoverWrapper;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.Nullable;

class MoveStatementHandler
extends EditorWriteActionHandler {
    private final boolean isDown;

    public MoveStatementHandler(boolean down) {
        this.isDown = down;
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        Document document;
        Project project = editor.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file = MoveStatementHandler.getRoot(documentManager.getPsiFile(document = editor.getDocument()), editor);
        MoverWrapper mover = this.getSuitableMover(editor, file);
        if (mover != null) {
            mover.move(editor, file);
        }
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        if (editor.isViewer() || editor.isOneLineMode()) {
            return false;
        }
        Project project = editor.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        documentManager.commitDocument(document);
        PsiFile psiFile = documentManager.getPsiFile(document);
        PsiFile file = MoveStatementHandler.getRoot(psiFile, editor);
        if (file == null) {
            return false;
        }
        MoverWrapper mover = this.getSuitableMover(editor, file);
        if (mover == null || mover.getInfo().toMove2 == null) {
            return false;
        }
        int maxLine = editor.offsetToLogicalPosition((int)editor.getDocument().getTextLength()).line;
        LineRange range = mover.getInfo().toMove;
        if (range.startLine == 0 && !this.isDown) {
            return false;
        }
        return range.endLine < maxLine || !this.isDown;
    }

    @Nullable
    private static PsiFile getRoot(PsiFile file, Editor editor) {
        if (file == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            --offset;
        }
        if (offset < 0) {
            return null;
        }
        PsiElement leafElement = file.findElementAt(offset);
        if (leafElement == null) {
            return null;
        }
        if (leafElement.getLanguage() instanceof DependentLanguage && (leafElement = file.getViewProvider().findElementAt(offset, file.getViewProvider().getBaseLanguage())) == null) {
            return null;
        }
        ASTNode node = leafElement.getNode();
        if (node == null) {
            return null;
        }
        return (PsiFile)PsiUtilBase.getRoot((ASTNode)node).getPsi();
    }

    @Nullable
    private MoverWrapper getSuitableMover(Editor editor, PsiFile file) {
        StatementUpDownMover[] movers = (StatementUpDownMover[])Extensions.getExtensions((ExtensionPointName)StatementUpDownMover.STATEMENT_UP_DOWN_MOVER_EP);
        StatementUpDownMover.MoveInfo info = new StatementUpDownMover.MoveInfo();
        for (StatementUpDownMover mover : movers) {
            if (!mover.checkAvailable(editor, file, info, this.isDown)) continue;
            return new MoverWrapper(mover, info, this.isDown);
        }
        return null;
    }
}

