/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateClassDialog
extends DialogWrapper {
    private final JLabel myInformationLabel;
    private final JLabel myPackageLabel;
    private final ReferenceEditorComboWithBrowseButton myPackageComponent;
    private final JTextField myTfClassName;
    private final Project myProject;
    private PsiDirectory myTargetDirectory;
    private final String myClassName;
    private final boolean myClassNameEditable;
    private final Module myModule;
    @NonNls
    private static final String RECENTS_KEY = "CreateClassDialog.RecentsKey";

    public CreateClassDialog(@NotNull Project project, @NotNull String title, String targetClassName, String targetPackageName, @NotNull CreateClassKind kind, boolean classNameEditable, Module defaultModule) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/CreateClassDialog.<init> must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/impl/CreateClassDialog.<init> must not be null");
        }
        if (kind == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/intention/impl/CreateClassDialog.<init> must not be null");
        }
        super(project, true);
        this.myInformationLabel = new JLabel("#");
        this.myPackageLabel = new JLabel(CodeInsightBundle.message((String)"dialog.create.class.destination.package.label", (Object[])new Object[0]));
        this.myTfClassName = new MyTextField();
        this.myClassNameEditable = classNameEditable;
        this.myModule = defaultModule;
        this.myClassName = targetClassName;
        this.myProject = project;
        this.myPackageComponent = new PackageNameReferenceEditorCombo(targetPackageName != null ? targetPackageName : "", this.myProject, RECENTS_KEY, CodeInsightBundle.message((String)"dialog.create.class.package.chooser.title", (Object[])new Object[0]));
        this.myPackageComponent.setTextFieldPreferredWidth(40);
        this.init();
        if (!this.myClassNameEditable) {
            this.setTitle(CodeInsightBundle.message((String)"dialog.create.class.name", (Object[])new Object[]{kind.getDescription(), targetClassName}));
        } else {
            this.myInformationLabel.setText(CodeInsightBundle.message((String)"dialog.create.class.label", (Object[])new Object[]{kind.getDescription()}));
            this.setTitle(title);
        }
        this.myTfClassName.setText(this.myClassName);
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameEditable ? this.myTfClassName : this.myPackageComponent.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        if (this.myClassNameEditable) {
            gbConstraints.weightx = 0.0;
            gbConstraints.gridwidth = 1;
            panel.add((Component)this.myInformationLabel, gbConstraints);
            panel.setBorder(IdeBorderFactory.createBorder());
            gbConstraints.insets = new Insets(4, 8, 4, 8);
            gbConstraints.gridx = 1;
            gbConstraints.weightx = 1.0;
            gbConstraints.gridwidth = 1;
            gbConstraints.fill = 2;
            gbConstraints.anchor = 17;
            panel.add((Component)this.myTfClassName, gbConstraints);
            this.myTfClassName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    CreateClassDialog.this.getOKAction().setEnabled(JavaPsiFacade.getInstance((Project)CreateClassDialog.this.myProject).getNameHelper().isIdentifier(CreateClassDialog.this.myTfClassName.getText()));
                }
            });
            this.getOKAction().setEnabled(StringUtil.isNotEmpty((String)this.myClassName));
        }
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 2;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        panel.add((Component)this.myPackageLabel, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                CreateClassDialog.this.myPackageComponent.getButton().doClick();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), this.myPackageComponent.getChildComponent());
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)((Object)this.myPackageComponent), "Center");
        panel.add((Component)_panel, gbConstraints);
        return panel;
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    private String getPackageName() {
        String name = this.myPackageComponent.getText();
        return name != null ? name.trim() : "";
    }

    protected void doOKAction() {
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENTS_KEY, this.myPackageComponent.getText());
        final String packageName = this.getPackageName();
        final String[] errorString = new String[1];
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                try {
                    PsiDirectory baseDir = CreateClassDialog.this.myModule == null ? null : PackageUtil.findPossiblePackageDirectoryInModule(CreateClassDialog.this.myModule, packageName);
                    CreateClassDialog.this.myTargetDirectory = CreateClassDialog.this.myModule == null ? PackageUtil.findOrCreateDirectoryForPackage(CreateClassDialog.this.myProject, packageName, baseDir, true) : PackageUtil.findOrCreateDirectoryForPackage(CreateClassDialog.this.myModule, packageName, baseDir, true);
                    if (CreateClassDialog.this.myTargetDirectory == null) {
                        errorString[0] = "";
                        return;
                    }
                    errorString[0] = RefactoringMessageUtil.checkCanCreateClass(CreateClassDialog.this.myTargetDirectory, CreateClassDialog.this.getClassName());
                }
                catch (IncorrectOperationException e) {
                    errorString[0] = e.getMessage();
                }
            }
        }, CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0]), null);
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)errorString[0], (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            }
            return;
        }
        super.doOKAction();
    }

    public String getClassName() {
        if (this.myClassNameEditable) {
            return this.myTfClassName.getText();
        }
        return this.myClassName;
    }

    private static class MyTextField
    extends JTextField {
        private MyTextField() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            size.width = fontMetrics.charWidth('a') * 40;
            return size;
        }
    }
}

