/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetRendererProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.Arrays;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class GotoTargetHandler
implements CodeInsightActionHandler {
    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/GotoTargetHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/navigation/GotoTargetHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/navigation/GotoTargetHandler.invoke must not be null");
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureUsedKey());
        try {
            Pair<PsiElement, PsiElement[]> sourceAndTarget = this.getSourceAndTargetElements(editor, file);
            if (sourceAndTarget.first != null) {
                this.show(project, editor, file, (PsiElement)sourceAndTarget.first, (PsiElement[])sourceAndTarget.second);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Navigation is not available here during index update");
        }
    }

    @NonNls
    protected abstract String getFeatureUsedKey();

    protected abstract Pair<PsiElement, PsiElement[]> getSourceAndTargetElements(Editor var1, PsiFile var2);

    private void show(Project project, Editor editor, PsiFile file, PsiElement sourceElement, PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            this.handleNoVariansCase(project, editor, file);
            return;
        }
        if (elements.length == 1) {
            Navigatable descriptor;
            Navigatable navigatable = descriptor = elements[0] instanceof Navigatable ? (Navigatable)elements[0] : EditSourceUtil.getDescriptor((PsiElement)elements[0]);
            if (descriptor != null && descriptor.canNavigate()) {
                this.navigateToElement(descriptor);
            }
        } else {
            String titleKey;
            GotoTargetRendererProvider provider;
            PsiElementListCellRenderer renderer = null;
            GotoTargetRendererProvider[] arr$ = (GotoTargetRendererProvider[])Extensions.getExtensions(GotoTargetRendererProvider.EP_NAME);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (renderer = (provider = arr$[i$]).getRenderer(elements)) == null; ++i$) {
            }
            if (renderer == null) {
                renderer = new DefaultPsiElementListCellRenderer();
                titleKey = this.getChooserInFileTitleKey(sourceElement);
            } else {
                titleKey = this.getChooserTitleKey(sourceElement);
            }
            String name = ((PsiNamedElement)sourceElement).getName();
            String title = CodeInsightBundle.message((String)titleKey, (Object[])new Object[]{name, elements.length});
            if (this.shouldSortResult()) {
                Arrays.sort(elements, renderer.getComparator());
            }
            final JList<PsiElement> list = new JList<PsiElement>(elements);
            list.setCellRenderer(renderer);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object[] selectedElements;
                    int[] ids = list.getSelectedIndices();
                    if (ids == null || ids.length == 0) {
                        return;
                    }
                    for (Object element : selectedElements = list.getSelectedValues()) {
                        Navigatable descriptor;
                        Navigatable navigatable = descriptor = element instanceof Navigatable ? (Navigatable)element : EditSourceUtil.getDescriptor((PsiElement)((PsiElement)element));
                        if (descriptor == null || !descriptor.canNavigate()) continue;
                        GotoTargetHandler.this.navigateToElement(descriptor);
                    }
                }
            };
            PopupChooserBuilder builder = new PopupChooserBuilder(list);
            renderer.installSpeedSearch(builder);
            builder.setTitle(title).setItemChoosenCallback(runnable).setMovable(true).createPopup().showInBestPositionFor(editor);
        }
    }

    protected void navigateToElement(Navigatable descriptor) {
        descriptor.navigate(true);
    }

    protected boolean shouldSortResult() {
        return true;
    }

    protected void handleNoVariansCase(Project project, Editor editor, PsiFile file) {
    }

    protected abstract String getChooserInFileTitleKey(PsiElement var1);

    protected abstract String getChooserTitleKey(PsiElement var1);

    private static class DefaultPsiElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DefaultPsiElementListCellRenderer() {
        }

        public String getElementText(PsiElement element) {
            return element.getContainingFile().getName();
        }

        protected String getContainerText(PsiElement element, String name) {
            return null;
        }

        @Override
        protected int getIconFlags() {
            return 0;
        }
    }
}

