/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.logging.IndependentLogFilter;
import com.intellij.diagnostic.logging.LogConsolePreferences;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;

public class DefaultLogFilterModel
extends LogFilterModel {
    private final Project myProject;
    private boolean myCheckStandartFilters = true;
    private String myPrevType = null;

    public DefaultLogFilterModel(Project project) {
        this.myProject = project;
    }

    protected LogConsolePreferences getPreferences() {
        return LogConsolePreferences.getInstance((Project)this.myProject);
    }

    public boolean isCheckStandartFilters() {
        return this.myCheckStandartFilters;
    }

    public void setCheckStandartFilters(boolean checkStandartFilters) {
        this.myCheckStandartFilters = checkStandartFilters;
    }

    public void updateCustomFilter(String filter) {
        super.updateCustomFilter(filter);
        this.getPreferences().updateCustomFilter(filter);
    }

    public String getCustomFilter() {
        return this.getPreferences().CUSTOM_FILTER;
    }

    public void addFilterListener(LogFilterListener listener) {
        this.getPreferences().addFilterListener(listener);
    }

    public boolean isApplicable(String line) {
        if (!super.isApplicable(line)) {
            return false;
        }
        return this.getPreferences().isApplicable(line, this.myPrevType, this.myCheckStandartFilters);
    }

    public void removeFilterListener(LogFilterListener listener) {
        this.getPreferences().removeFilterListener(listener);
    }

    public List<LogFilter> getLogFilters() {
        LogConsolePreferences prefs = this.getPreferences();
        ArrayList<LogFilter> filters = new ArrayList<LogFilter>();
        if (this.myCheckStandartFilters) {
            this.addStandartFilters(filters, prefs);
        }
        filters.addAll(prefs.getRegisteredLogFilters());
        return filters;
    }

    private void addStandartFilters(ArrayList<LogFilter> filters, final LogConsolePreferences prefs) {
        filters.add((LogFilter)new MyFilter(DiagnosticBundle.message("log.console.filter.show.all", new Object[0]), prefs){

            public void selectFilter() {
                prefs.FILTER_ERRORS = false;
                prefs.FILTER_INFO = false;
                prefs.FILTER_WARNINGS = false;
                prefs.FILTER_DEBUG = false;
            }

            public boolean isSelected() {
                return !prefs.FILTER_ERRORS && !prefs.FILTER_INFO && !prefs.FILTER_WARNINGS && !prefs.FILTER_DEBUG;
            }
        });
        filters.add((LogFilter)new MyFilter(DiagnosticBundle.message("log.console.filter.show.errors.warnings.and.infos", new Object[0]), prefs){

            public void selectFilter() {
                prefs.FILTER_ERRORS = false;
                prefs.FILTER_INFO = false;
                prefs.FILTER_WARNINGS = false;
                prefs.FILTER_DEBUG = true;
            }

            public boolean isSelected() {
                return !prefs.FILTER_ERRORS && !prefs.FILTER_INFO && !prefs.FILTER_WARNINGS && prefs.FILTER_DEBUG;
            }
        });
        filters.add((LogFilter)new MyFilter(DiagnosticBundle.message("log.console.filter.show.errors.and.warnings", new Object[0]), prefs){

            public void selectFilter() {
                prefs.FILTER_ERRORS = false;
                prefs.FILTER_INFO = true;
                prefs.FILTER_WARNINGS = false;
                prefs.FILTER_DEBUG = true;
            }

            public boolean isSelected() {
                return !prefs.FILTER_ERRORS && prefs.FILTER_INFO && !prefs.FILTER_WARNINGS && prefs.FILTER_DEBUG;
            }
        });
        filters.add((LogFilter)new MyFilter(DiagnosticBundle.message("log.console.filter.show.errors", new Object[0]), prefs){

            public void selectFilter() {
                prefs.FILTER_ERRORS = false;
                prefs.FILTER_INFO = true;
                prefs.FILTER_WARNINGS = true;
                prefs.FILTER_DEBUG = true;
            }

            public boolean isSelected() {
                return !prefs.FILTER_ERRORS && prefs.FILTER_INFO && prefs.FILTER_WARNINGS && prefs.FILTER_DEBUG;
            }
        });
    }

    public boolean isFilterSelected(LogFilter filter) {
        return this.getPreferences().isFilterSelected(filter);
    }

    public void selectFilter(LogFilter filter) {
        this.getPreferences().selectOnlyFilter(filter);
    }

    public Key processLine(String line) {
        Key contentType;
        String type = LogConsolePreferences.getType((String)line);
        Key key = type != null ? LogConsolePreferences.getProcessOutputTypes((String)type) : (contentType = this.myPrevType == "ERROR" ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT);
        if (type != null) {
            this.myPrevType = type;
        }
        return contentType;
    }

    private abstract class MyFilter
    extends IndependentLogFilter {
        private final LogConsolePreferences myPrefs;

        protected MyFilter(String name, LogConsolePreferences prefs) {
            super(name);
            this.myPrefs = prefs;
        }

        public boolean isAcceptable(String line) {
            return this.myPrefs.isApplicable(line, DefaultLogFilterModel.this.myPrevType, DefaultLogFilterModel.this.myCheckStandartFilters);
        }
    }
}

