/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.autodetecting.FacetDetector;
import com.intellij.facet.autodetecting.UnderlyingFacetSelector;
import com.intellij.facet.impl.autodetecting.AutodetectionFilter;
import com.intellij.facet.impl.autodetecting.FacetDetectorWrapper;
import com.intellij.facet.impl.autodetecting.model.FacetInfo2;
import com.intellij.facet.impl.autodetecting.model.ProjectFacetInfoSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;

public class FacetByPsiFileDetectorWrapper<C extends FacetConfiguration, F extends Facet<C>, U extends FacetConfiguration>
extends FacetDetectorWrapper<PsiFile, C, F, U> {
    private final Condition<PsiFile> myPsiFileFilter;

    public FacetByPsiFileDetectorWrapper(ProjectFacetInfoSet projectFacetSet, FacetType<F, C> facetType, AutodetectionFilter autodetectionFilter, VirtualFileFilter virtualFileFilter, FacetDetector<PsiFile, C> facetDetector, Condition<PsiFile> psiFileFilter, UnderlyingFacetSelector<VirtualFile, U> selector) {
        super(projectFacetSet, facetType, autodetectionFilter, virtualFileFilter, facetDetector, selector);
        this.myPsiFileFilter = psiFileFilter;
    }

    @Override
    public FacetInfo2<Module> detectFacet(VirtualFile virtualFile, PsiManager psiManager) {
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null || !this.myPsiFileFilter.value((Object)psiFile)) {
            return null;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)psiManager.getProject());
        if (module == null) {
            return null;
        }
        return this.detectFacet(module, virtualFile, psiFile);
    }
}

