/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting.facetsTree;

import com.intellij.facet.FacetType;
import com.intellij.facet.autodetecting.DetectedFacetPresentation;
import com.intellij.facet.impl.autodetecting.FacetDetectorRegistryEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class DetectedFacetsTree
extends CheckboxTreeBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.autodetecting.facetsTree.DetectedFacetsTree");
    private static final Icon MODULE_ICON = IconLoader.getIcon((String)"/nodes/ModuleClosed.png");

    public DetectedFacetsTree(Collection<? extends CheckedTreeNode> roots) {
        super((CheckboxTreeBase.CheckboxTreeCellRendererBase)new FacetsCheckboxTreeCellRenderer(), DetectedFacetsTree.createRoot(roots), new CheckboxTreeBase.CheckPolicy(true, true, true, false));
    }

    private static CheckedTreeNode createRoot(Collection<? extends CheckedTreeNode> nodes) {
        CheckedTreeNode root = new CheckedTreeNode(null);
        for (CheckedTreeNode checkedTreeNode : nodes) {
            if (!(checkedTreeNode instanceof FacetTypeNode || checkedTreeNode instanceof ModuleNode || checkedTreeNode instanceof FacetNode)) {
                LOG.error("incorrect node class: " + checkedTreeNode.getClass().getName());
            }
            root.add((MutableTreeNode)checkedTreeNode);
        }
        return root;
    }

    @Nullable
    public CheckedTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        return path != null ? (CheckedTreeNode)path.getLastPathComponent() : null;
    }

    public static class FacetNode
    extends CheckedTreeNode {
        private final VirtualFile[] myFiles;
        private final FacetType<?, ?> myFacetType;
        private final VirtualFile myProjectRoot;
        private final List<FacetNode> myChildren = new ArrayList<FacetNode>();

        public FacetNode(Object userObject, FacetType facetType, VirtualFile projectRoot, VirtualFile[] files, @Nullable FacetNode parent) {
            super(userObject);
            this.myFacetType = facetType;
            this.myProjectRoot = projectRoot;
            this.myFiles = files;
            if (parent != null) {
                parent.myChildren.add(this);
                parent.add((MutableTreeNode)((Object)this));
            }
        }

        public String getName() {
            return this.myFacetType.getPresentableName();
        }

        public VirtualFile[] getFiles() {
            return this.myFiles;
        }

        public List<FacetNode> getChildren() {
            return this.myChildren;
        }

        public FacetType getFacetType() {
            return this.myFacetType;
        }

        @Nullable
        public String getDescription() {
            DetectedFacetPresentation presentation = FacetDetectorRegistryEx.getDetectedFacetPresentation(this.myFacetType);
            return presentation.getDetectedFacetDescription(this.myProjectRoot, this.myFiles);
        }
    }

    public static class FacetTypeNode
    extends CheckedTreeNode {
        private final FacetType myFacetType;
        private final List<ModuleNode> myModuleNodes = new ArrayList<ModuleNode>();

        public FacetTypeNode(FacetType facetType) {
            super((Object)facetType);
            this.myFacetType = facetType;
        }

        public FacetType getFacetType() {
            return this.myFacetType;
        }

        public void addModuleNode(ModuleNode moduleNode) {
            this.myModuleNodes.add(moduleNode);
            this.add((MutableTreeNode)((Object)moduleNode));
        }

        public List<ModuleNode> getModuleNodes() {
            return this.myModuleNodes;
        }
    }

    public static abstract class ModuleNode
    extends CheckedTreeNode {
        private final List<FacetNode> myRootFacets = new ArrayList<FacetNode>();

        public ModuleNode(Object userObject) {
            super(userObject);
        }

        public abstract String getModuleName();

        public abstract String getModuleDescription();

        public void addRootFacet(FacetNode facetInfo) {
            this.myRootFacets.add(facetInfo);
            this.add((MutableTreeNode)((Object)facetInfo));
        }

        public List<FacetNode> getRootFacets() {
            return this.myRootFacets;
        }
    }

    private static class FacetsCheckboxTreeCellRenderer
    extends CheckboxTreeBase.CheckboxTreeCellRendererBase {
        private FacetsCheckboxTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (value instanceof ModuleNode) {
                ModuleNode moduleNode = (ModuleNode)((Object)value);
                renderer.setIcon(MODULE_ICON);
                renderer.append(moduleNode.getModuleName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                renderer.append(moduleNode.getModuleDescription(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else if (value instanceof FacetNode) {
                FacetNode node = (FacetNode)((Object)value);
                FacetType type = node.getFacetType();
                renderer.setIcon(type.getIcon());
                renderer.append(node.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String description = node.getDescription();
                if (description != null) {
                    renderer.append(" (" + description + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else if (value instanceof FacetTypeNode) {
                FacetType type = ((FacetTypeNode)((Object)value)).getFacetType();
                renderer.setIcon(type.getIcon());
                renderer.append(ProjectBundle.message((String)"detected.facet.type.node", (Object[])new Object[]{type.getPresentableName()}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }
}

