/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.Paths;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.DirectoryEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Entry {
    protected int myId;
    protected String myName;
    protected DirectoryEntry myParent;

    public Entry(int id, String name) {
        this.myId = id;
        this.myName = name;
    }

    public Entry(Stream s) throws IOException {
        this.myId = s.readInteger();
        this.myName = s.readString();
    }

    public void write(Stream s) throws IOException {
        s.writeInteger(this.myId);
        s.writeString(this.myName);
    }

    public int getId() {
        return this.myId;
    }

    public IdPath getIdPath() {
        if (this.myParent == null) {
            return new IdPath(this.myId);
        }
        return this.myParent.getIdPath().appendedWith(this.myId);
    }

    public String getName() {
        return this.myName;
    }

    public String getPath() {
        if (this.myParent == null) {
            return this.myName;
        }
        return this.myParent.getPathAppendedWith(this.myName);
    }

    public boolean nameEquals(String name) {
        return Paths.equals(this.myName, name);
    }

    public boolean pathEquals(String path) {
        return Paths.equals(this.getPath(), path);
    }

    public long getTimestamp() {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public boolean isReadOnly() {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public boolean isOutdated(long timestamp) {
        return this.getTimestamp() != timestamp;
    }

    public Content getContent() {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public boolean hasUnavailableContent() {
        return this.hasUnavailableContent(new ArrayList<Entry>());
    }

    public boolean hasUnavailableContent(List<Entry> entriesWithUnavailableContent) {
        return false;
    }

    public Entry getParent() {
        return this.myParent;
    }

    protected void setParent(DirectoryEntry parent) {
        this.myParent = parent;
    }

    public boolean isDirectory() {
        return false;
    }

    public void addChild(Entry child) {
        throw new UnsupportedOperationException(this.formatAddRemove(child));
    }

    public void removeChild(Entry child) {
        throw new UnsupportedOperationException(this.formatAddRemove(child));
    }

    private String formatAddRemove(Entry child) {
        return "add/remove " + child.formatPath() + " to " + this.formatPath();
    }

    public List<Entry> getChildren() {
        return Collections.emptyList();
    }

    public Entry findChild(String name) {
        for (Entry e : this.getChildren()) {
            if (!e.nameEquals(name)) continue;
            return e;
        }
        return null;
    }

    public boolean hasEntry(String path) {
        return this.findEntry(path) != null;
    }

    public Entry getEntry(String path) {
        Entry result = this.findEntry(path);
        if (result == null) {
            throw new RuntimeException(String.format("entry '%s' not found", path));
        }
        return result;
    }

    public Entry findEntry(String path) {
        String withoutMe = Paths.withoutRootIfUnder(path, this.myName);
        if (withoutMe == null) {
            return null;
        }
        if (withoutMe.length() == 0) {
            return this;
        }
        return this.searchInChildren(withoutMe);
    }

    protected Entry searchInChildren(String path) {
        for (Entry e : this.getChildren()) {
            Entry result = e.findEntry(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Entry findEntry(IdPath p) {
        if (!p.rootEquals(this.myId)) {
            return null;
        }
        if (p.getId() == this.myId) {
            return this;
        }
        return this.searchInChildren(p.withoutRoot());
    }

    protected Entry searchInChildren(IdPath p) {
        for (Entry e : this.getChildren()) {
            Entry result = e.findEntry(p);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Entry getEntry(IdPath p) {
        Entry result = this.findEntry(p);
        if (result == null) {
            throw new RuntimeException(String.format("entry '%s' not found", p.toString()));
        }
        return result;
    }

    public Entry getEntry(int id) {
        Entry result = this.findEntry(id);
        if (result == null) {
            throw new RuntimeException(String.format("entry #%d not found", id));
        }
        return result;
    }

    private Entry findEntry(int id) {
        if (id == this.myId) {
            return this;
        }
        for (Entry child : this.getChildren()) {
            Entry result = child.findEntry(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public abstract Entry copy();

    public void changeName(String newName) {
        if (this.myParent != null) {
            this.myParent.checkDoesNotExist(this, newName);
        }
        this.myName = newName;
    }

    public void changeContent(Content newContent, long timestamp) {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public List<Difference> getDifferencesWith(Entry e) {
        ArrayList<Difference> result = new ArrayList<Difference>();
        this.collectDifferencesWith(e, result);
        return result;
    }

    public abstract void collectDifferencesWith(Entry var1, List<Difference> var2);

    protected abstract void collectCreatedDifferences(List<Difference> var1);

    protected abstract void collectDeletedDifferences(List<Difference> var1);

    public String toString() {
        return String.valueOf(this.myId) + "-" + this.myName;
    }

    private String formatPath() {
        String type = this.isDirectory() ? "dir: " : "file: ";
        return type + this.getPath();
    }
}

