/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public abstract class WindowAction
extends AnAction {
    public static final String NO_WINDOW_ACTIONS = "no.window.actions";
    protected Window myWindow;
    private static JLabel mySizeHelper = new JLabel("W");

    public WindowAction() {
        this.setEnabledInModalContext(true);
    }

    public final void update(AnActionEvent e) {
        Window wnd = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        e.getPresentation().setEnabled(wnd != null && !(wnd instanceof IdeFrame));
        Object noActions = null;
        if (wnd instanceof JDialog) {
            noActions = ((JDialog)wnd).getRootPane().getClientProperty(NO_WINDOW_ACTIONS);
        } else if (wnd instanceof JFrame) {
            noActions = ((JFrame)wnd).getRootPane().getClientProperty(NO_WINDOW_ACTIONS);
        }
        if (noActions != null && "true".equalsIgnoreCase(noActions.toString())) {
            e.getPresentation().setEnabled(false);
        }
        this.myWindow = e.getPresentation().isEnabled() ? wnd : null;
    }

    public static class DecrementHeight
    extends BaseSizeAction {
        public DecrementHeight() {
            super(false, false);
        }
    }

    public static class IncrementHeight
    extends BaseSizeAction {
        public IncrementHeight() {
            super(false, true);
        }
    }

    public static class DecrementWidth
    extends BaseSizeAction {
        public DecrementWidth() {
            super(true, false);
        }
    }

    public static class IncrementWidth
    extends BaseSizeAction {
        public IncrementWidth() {
            super(true, true);
        }
    }

    public static abstract class BaseSizeAction
    extends WindowAction {
        private boolean myHorizontal;
        private boolean myPositive;

        protected BaseSizeAction(boolean horizontal, boolean positive) {
            this.myHorizontal = horizontal;
            this.myPositive = positive;
        }

        public void actionPerformed(AnActionEvent e) {
            int baseValue = this.myHorizontal ? mySizeHelper.getPreferredSize().width : mySizeHelper.getPreferredSize().height;
            int inc = baseValue * (this.myHorizontal ? Registry.intValue((String)"ide.windowSystem.hScrollChars") : Registry.intValue((String)"ide.windowSystem.vScrollChars"));
            if (!this.myPositive) {
                inc = -inc;
            }
            Rectangle bounds = this.myWindow.getBounds();
            if (this.myHorizontal) {
                bounds.width += inc;
            } else {
                bounds.height += inc;
            }
            this.myWindow.setBounds(bounds);
        }
    }
}

