/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.smartPointerPsiNodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilBase;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSmartPointerPsiNode<Type extends SmartPsiElementPointer>
extends ProjectViewNode<Type> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.impl.nodes.BasePsiNode");

    protected BaseSmartPointerPsiNode(Project project, Type value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<AbstractTreeNode> getChildren() {
        Collection<AbstractTreeNode> collection;
        PsiElement value = this.getPsiElement();
        if (value == null) {
            collection = new ArrayList<AbstractTreeNode>();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/smartPointerPsiNodes/BaseSmartPointerPsiNode.getChildren must not return null");
            return collection;
        }
        LOG.assertTrue(value.isValid());
        collection = this.getChildrenImpl();
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/smartPointerPsiNodes/BaseSmartPointerPsiNode.getChildren must not return null");
    }

    @NotNull
    protected abstract Collection<AbstractTreeNode> getChildrenImpl();

    protected boolean isMarkReadOnly() {
        Object parentValue = this.getParentValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof PackageElement;
    }

    public FileStatus getFileStatus() {
        VirtualFile file = this.getVirtualFileForValue();
        if (file == null) {
            return FileStatus.NOT_CHANGED;
        }
        return FileStatusManager.getInstance((Project)this.getProject()).getStatus(file);
    }

    private VirtualFile getVirtualFileForValue() {
        PsiElement value = this.getPsiElement();
        if (value == null) {
            return null;
        }
        return PsiUtilBase.getVirtualFile((PsiElement)value);
    }

    protected abstract void updateImpl(PresentationData var1);

    public void update(PresentationData data) {
        PsiElement value = this.getPsiElement();
        if (value == null || !value.isValid()) {
            this.setValue(null);
        }
        if (this.getPsiElement() == null) {
            return;
        }
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        LOG.assertTrue(value.isValid());
        Icon icon = value.getIcon(flags);
        data.setClosedIcon(icon);
        data.setOpenIcon(icon);
        data.setPresentableText(this.myName);
        if (this.isDeprecated()) {
            data.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
        }
        this.updateImpl(data);
        for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)this.myProject)) {
            decorator.decorate(this, data);
        }
    }

    private boolean isDeprecated() {
        PsiElement element = this.getPsiElement();
        return element instanceof PsiDocCommentOwner && element.isValid() && ((PsiDocCommentOwner)element).isDeprecated();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/smartPointerPsiNodes/BaseSmartPointerPsiNode.contains must not be null");
        }
        if (this.getPsiElement() == null) {
            return false;
        }
        PsiFile containingFile = this.getPsiElement().getContainingFile();
        return file.equals(containingFile.getVirtualFile());
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            ((NavigationItem)this.getPsiElement()).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.getPsiElement() instanceof NavigationItem && ((NavigationItem)this.getPsiElement()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getPsiElement() instanceof NavigationItem && ((NavigationItem)this.getPsiElement()).canNavigateToSource();
    }

    protected PsiElement getPsiElement() {
        SmartPsiElementPointer value = (SmartPsiElementPointer)this.getValue();
        return value == null ? null : value.getElement();
    }
}

