/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Properties;

public class DefaultCreateFromTemplateHandler
implements CreateFromTemplateHandler {
    @Override
    public boolean handlesTemplate(FileTemplate template) {
        return true;
    }

    @Override
    public PsiElement createFromTemplate(Project project, PsiDirectory directory, String fileName, FileTemplate template, String templateText, Properties props) throws IncorrectOperationException {
        fileName = this.checkAppendExtension(fileName, template);
        directory.checkCreateFile(fileName);
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, templateText);
        if (template.isAdjust()) {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
        }
        file = (PsiFile)directory.add((PsiElement)file);
        return file;
    }

    protected String checkAppendExtension(String fileName, FileTemplate template) {
        String suggestedFileNameEnd = "." + template.getExtension();
        if (!fileName.endsWith(suggestedFileNameEnd)) {
            fileName = fileName + suggestedFileNameEnd;
        }
        return fileName;
    }

    @Override
    public boolean canCreate(PsiDirectory[] dirs) {
        return true;
    }
}

